
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_george = m.addVar(name="hours_george", lb=0)
hours_paul = m.addVar(name="hours_paul", lb=0)
hours_ringo = m.addVar(name="hours_ringo", lb=0)
hours_mary = m.addVar(name="hours_mary", lb=0)

# Define the objective function
m.setObjective(2 * hours_george + 5 * hours_paul + 7 * hours_ringo + 7 * hours_mary, gp.GRB.MINIMIZE)

# Constraints
# The total combined dollar cost per hour from hours worked by Paul plus hours worked by Ringo has to be no less than 17.
m.addConstr(7 * hours_paul + 1 * hours_ringo >= 17, "cost_paul_ringo")

# The total combined dollar cost per hour from hours worked by Paul plus hours worked by Mary has to be as much or more than 23.
m.addConstr(7 * hours_paul + 12 * hours_mary >= 23, "cost_paul_mary")

# The total combined dollar cost per hour from hours worked by Ringo plus hours worked by Mary has to be 18 at a minimum.
m.addConstr(1 * hours_ringo + 12 * hours_mary >= 18, "cost_ringo_mary")

# The total combined dollar cost per hour from hours worked by George, hours worked by Paul, hours worked by Ringo, and hours worked by Mary should be 18 at a minimum.
m.addConstr(3 * hours_george + 7 * hours_paul + 1 * hours_ringo + 12 * hours_mary >= 18, "cost_all")

# Productivity ratings constraints
m.addConstr(4 * hours_george + 9 * hours_ringo >= 48, "productivity_george_ringo")
m.addConstr(4 * hours_george + 12 * hours_paul >= 22, "productivity_george_paul")
m.addConstr(4 * hours_george + 7 * hours_mary >= 37, "productivity_george_mary")
m.addConstr(4 * hours_george + 12 * hours_paul + 7 * hours_mary >= 46, "productivity_george_paul_mary")
m.addConstr(12 * hours_paul + 9 * hours_ringo + 7 * hours_mary >= 46, "productivity_paul_ringo_mary")
m.addConstr(4 * hours_george + 9 * hours_ringo + 7 * hours_mary >= 46, "productivity_george_ringo_mary")
m.addConstr(4 * hours_george + 12 * hours_paul + 9 * hours_ringo >= 46, "productivity_george_paul_ringo")
m.addConstr(4 * hours_george + 12 * hours_paul + 7 * hours_mary >= 50, "productivity_george_paul_mary_50")
m.addConstr(12 * hours_paul + 9 * hours_ringo + 7 * hours_mary >= 50, "productivity_paul_ringo_mary_50")
m.addConstr(4 * hours_george + 9 * hours_ringo + 7 * hours_mary >= 50, "productivity_george_ringo_mary_50")
m.addConstr(4 * hours_george + 12 * hours_paul + 9 * hours_ringo >= 50, "productivity_george_paul_ringo_50")
m.addConstr(4 * hours_george + 12 * hours_paul + 7 * hours_mary >= 53, "productivity_george_paul_mary_53")
m.addConstr(12 * hours_paul + 9 * hours_ringo + 7 * hours_mary >= 53, "productivity_paul_ringo_mary_53")
m.addConstr(4 * hours_george + 9 * hours_ringo + 7 * hours_mary >= 53, "productivity_george_ringo_mary_53")
m.addConstr(4 * hours_george + 12 * hours_paul + 9 * hours_ringo >= 53, "productivity_george_paul_ringo_53")
m.addConstr(4 * hours_george + 12 * hours_paul + 7 * hours_mary >= 51, "productivity_george_paul_mary_51")
m.addConstr(12 * hours_paul + 9 * hours_ringo + 7 * hours_mary >= 51, "productivity_paul_ringo_mary_51")
m.addConstr(4 * hours_george + 9 * hours_ringo + 7 * hours_mary >= 51, "productivity_george_ringo_mary_51")
m.addConstr(4 * hours_george + 12 * hours_paul + 9 * hours_ringo >= 51, "productivity_george_paul_ringo_51")
m.addConstr(4 * hours_george + 12 * hours_paul + 9 * hours_ringo + 7 * hours_mary >= 51, "productivity_all")

# Computer competence ratings constraints
m.addConstr(4 * hours_george + 4 * hours_mary >= 24, "computer_george_mary")
m.addConstr(12 * hours_paul + 5 * hours_ringo >= 10, "computer_paul_ringo")
m.addConstr(4 * hours_george + 12 * hours_paul >= 16, "computer_george_paul")
m.addConstr(4 * hours_george + 12 * hours_paul + 5 * hours_ringo + 4 * hours_mary >= 16, "computer_all")

# Paperwork competence ratings constraints
m.addConstr(1 * hours_paul + 6 * hours_ringo >= 29, "paperwork_paul_ringo")
m.addConstr(9 * hours_george + 2 * hours_mary >= 24, "paperwork_george_mary")
m.addConstr(1 * hours_paul + 2 * hours_mary >= 25, "paperwork_paul_mary")
m.addConstr(9 * hours_george + 6 * hours_ringo >= 18, "paperwork_george_ringo")
m.addConstr(9 * hours_george + 1 * hours_paul + 6 * hours_ringo + 2 * hours_mary >= 18, "paperwork_all")

# Other constraints
m.addConstr(-1 * hours_paul + 1 * hours_ringo >= 0, "hours_paul_ringo")

# Dollar cost constraints
m.addConstr(3 * hours_george + 7 * hours_paul <= 67, "cost_george_paul")
m.addConstr(3 * hours_george + 7 * hours_paul + 12 * hours_mary <= 39, "cost_george_paul_mary")
m.addConstr(3 * hours_george + 1 * hours_ringo + 12 * hours_mary <= 77, "cost_george_ringo_mary")
m.addConstr(7 * hours_paul + 1 * hours_ringo + 12 * hours_mary <= 87, "cost_paul_ringo_mary")

# Productivity upper bounds
m.addConstr(12 * hours_paul + 9 * hours_ringo + 7 * hours_mary <= 152, "productivity_upper")

# Computer competence upper bounds
m.addConstr(4 * hours_george + 5 * hours_ringo <= 99, "computer_george_ringo")
m.addConstr(12 * hours_paul + 4 * hours_mary <= 25, "computer_paul_mary")
m.addConstr(5 * hours_ringo + 4 * hours_mary <= 62, "computer_ringo_mary")
m.addConstr(4 * hours_george + 12 * hours_paul <= 41, "computer_george_paul")
m.addConstr(12 * hours_paul + 5 * hours_ringo + 4 * hours_mary <= 59, "computer_paul_ringo_mary")
m.addConstr(4 * hours_george + 12 * hours_paul + 4 * hours_mary <= 87, "computer_george_paul_mary")

# Paperwork upper bounds
m.addConstr(9 * hours_george + 2 * hours_mary <= 117, "paperwork_george_mary")
m.addConstr(1 * hours_paul + 6 * hours_ringo + 2 * hours_mary <= 137, "paperwork_paul_ringo_mary")
m.addConstr(9 * hours_george + 1 * hours_paul + 2 * hours_mary <= 140, "paperwork_george_paul_mary")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Hours worked by George: ", hours_george.varValue)
    print("Hours worked by Paul: ", hours_paul.varValue)
    print("Hours worked by Ringo: ", hours_ringo.varValue)
    print("Hours worked by Mary: ", hours_mary.varValue)
    print("Objective: ", m.objVal)
else:
    print("No optimal solution found")
