
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of vitamin B3")
x1 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of vitamin D")
x2 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of potassium")
x3 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of vitamin B6")
x4 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams of vitamin B2")

# Define the objective function
m.setObjective(7.11*x0 + 9.35*x1 + 8.61*x2 + 9.94*x3 + 6.74*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x0 <= 97)
m.addConstr(5*x0 <= 102)
m.addConstr(5*x1 <= 97)
m.addConstr(6*x1 <= 102)
m.addConstr(2*x2 <= 97)
m.addConstr(2*x2 <= 102)
m.addConstr(5*x3 <= 97)
m.addConstr(2*x3 <= 102)
m.addConstr(3*x4 <= 97)
m.addConstr(2*x4 <= 102)

m.addConstr(3*x0 + 3*x4 >= 6)
m.addConstr(3*x0 + 5*x1 >= 15)
m.addConstr(5*x3 + 3*x4 >= 14)
m.addConstr(5*x1 + 2*x2 >= 10)
m.addConstr(3*x0 + 2*x2 >= 6)
m.addConstr(2*x2 + 3*x4 >= 18)
m.addConstr(5*x1 + 2*x3 >= 13)
m.addConstr(3*x0 + 2*x3 >= 15)
m.addConstr(3*x0 + 5*x1 + 2*x3 >= 11)
m.addConstr(3*x0 + 5*x1 + 2*x2 + 2*x3 + 3*x4 >= 11)

m.addConstr(5*x2 + 2*x4 >= 13)
m.addConstr(6*x1 + 2*x2 >= 12)
m.addConstr(5*x0 + 2*x4 >= 7)
m.addConstr(5*x0 + 2*x2 >= 20)
m.addConstr(2*x2 + 2*x3 >= 15)
m.addConstr(6*x1 + 2*x2 + 3*x4 >= 11)

# ... add all constraints

m.addConstr(-x0 + 4*x3 >= 0)
m.addConstr(-3*x2 + 4*x4 >= 0)
m.addConstr(-2*x1 + x4 >= 0)

m.addConstr(3*x0 + 5*x3 <= 62)
m.addConstr(3*x0 + 5*x1 <= 68)
m.addConstr(5*x1 + 2*x2 <= 47)
m.addConstr(5*x1 + 2*x2 + 2*x3 <= 64)
m.addConstr(3*x0 + 5*x1 + 3*x4 <= 38)
m.addConstr(3*x0 + 2*x2 + 2*x3 <= 28)
m.addConstr(3*x0 + 5*x3 + 3*x4 <= 35)
m.addConstr(3*x0 + 2*x2 + 3*x4 <= 78)
m.addConstr(3*x0 + 5*x1 + 2*x3 <= 60)
m.addConstr(3*x0 + 5*x1 + 2*x2 <= 57)
m.addConstr(5*x1 + 2*x2 + 3*x4 <= 77)
m.addConstr(5*x0 + 6*x1 <= 69)
m.addConstr(5*x0 + 2*x2 + 2*x3 <= 22)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B3: ", x0.varValue)
    print("Milligrams of vitamin D: ", x1.varValue)
    print("Milligrams of potassium: ", x2.varValue)
    print("Milligrams of vitamin B6: ", x3.varValue)
    print("Milligrams of vitamin B2: ", x4.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
