
from gurobipy import Model, GRB

# Create a new model
model = Model("optimize_work_hours")

# Create variables
john_hours = model.addVar(name="john_hours")
mary_hours = model.addVar(name="mary_hours")
bill_hours = model.addVar(name="bill_hours")
george_hours = model.addVar(name="george_hours")
jean_hours = model.addVar(name="jean_hours")

# Set objective function
model.setObjective(4 * john_hours + 2 * mary_hours + bill_hours + 3 * george_hours + 9 * jean_hours, GRB.MAXIMIZE)

# Likelihood to quit indices
quit_likelihood = {"john": 13, "mary": 20, "bill": 13, "george": 20, "jean": 21}

# Add constraints
model.addConstr(20 * mary_hours + 20 * george_hours + 21 * jean_hours >= 68)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours >= 68)
model.addConstr(13 * john_hours + 20 * george_hours + 21 * jean_hours >= 68)
model.addConstr(20 * mary_hours + 13 * bill_hours + 21 * jean_hours >= 68)
model.addConstr(13 * john_hours + 13 * bill_hours + 20 * george_hours >= 68)
model.addConstr(13 * john_hours + 13 * bill_hours + 21 * jean_hours >= 68)
model.addConstr(20 * mary_hours + 13 * bill_hours + 20 * george_hours >= 68)
model.addConstr(20 * mary_hours + 20 * george_hours + 21 * jean_hours >= 65)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours >= 65)
model.addConstr(13 * john_hours + 20 * george_hours + 21 * jean_hours >= 65)
model.addConstr(20 * mary_hours + 13 * bill_hours + 21 * jean_hours >= 65)
model.addConstr(13 * john_hours + 13 * bill_hours + 20 * george_hours >= 65)
model.addConstr(13 * john_hours + 13 * bill_hours + 21 * jean_hours >= 65)
model.addConstr(20 * mary_hours + 13 * bill_hours + 20 * george_hours >= 65)
model.addConstr(20 * mary_hours + 20 * george_hours + 21 * jean_hours >= 55)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours >= 55)
model.addConstr(13 * john_hours + 20 * george_hours + 21 * jean_hours >= 55)
model.addConstr(20 * mary_hours + 13 * bill_hours + 21 * jean_hours >= 55)
model.addConstr(13 * john_hours + 13 * bill_hours + 20 * george_hours >= 55)
model.addConstr(13 * john_hours + 13 * bill_hours + 21 * jean_hours >= 55)
model.addConstr(20 * mary_hours + 13 * bill_hours + 20 * george_hours >= 55)
model.addConstr(20 * mary_hours + 20 * george_hours + 21 * jean_hours >= 49)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours >= 49)
model.addConstr(13 * john_hours + 20 * george_hours + 21 * jean_hours >= 49)
model.addConstr(20 * mary_hours + 13 * bill_hours + 21 * jean_hours >= 49)
model.addConstr(13 * john_hours + 13 * bill_hours + 20 * george_hours >= 49)
model.addConstr(13 * john_hours + 13 * bill_hours + 21 * jean_hours >= 49)
model.addConstr(20 * mary_hours + 13 * bill_hours + 20 * george_hours >= 49)

model.addConstr(20 * mary_hours + 20 * george_hours + 21 * jean_hours >= 60)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours >= 60)
model.addConstr(13 * john_hours + 20 * george_hours + 21 * jean_hours >= 60)
model.addConstr(20 * mary_hours + 13 * bill_hours + 21 * jean_hours >= 60)
model.addConstr(13 * john_hours + 13 * bill_hours + 20 * george_hours >= 60)
model.addConstr(13 * john_hours + 13 * bill_hours + 21 * jean_hours >= 60)
model.addConstr(20 * mary_hours + 13 * bill_hours + 20 * george_hours >= 60)


model.addConstr(20 * mary_hours + 20 * george_hours + 21 * jean_hours >= 75)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours >= 75)
model.addConstr(13 * john_hours + 20 * george_hours + 21 * jean_hours >= 75)
model.addConstr(20 * mary_hours + 13 * bill_hours + 21 * jean_hours >= 75)
model.addConstr(13 * john_hours + 13 * bill_hours + 20 * george_hours >= 75)
model.addConstr(13 * john_hours + 13 * bill_hours + 21 * jean_hours >= 75)
model.addConstr(20 * mary_hours + 13 * bill_hours + 20 * george_hours >= 75)


model.addConstr(-7 * john_hours + 7 * bill_hours >= 0)
model.addConstr(-10 * mary_hours - 3 * george_hours + 4 * jean_hours >= 0)
model.addConstr(20 * mary_hours + 13 * bill_hours <= 124)
model.addConstr(13 * john_hours + 20 * mary_hours <= 340)
model.addConstr(13 * bill_hours + 20 * george_hours <= 86)
model.addConstr(13 * john_hours + 20 * george_hours <= 327)
model.addConstr(20 * mary_hours + 13 * bill_hours + 21 * jean_hours <= 124)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours <= 354)
model.addConstr(13 * john_hours + 20 * mary_hours + 21 * jean_hours <= 359)
model.addConstr(13 * john_hours + 13 * bill_hours + 20 * george_hours <= 226)
model.addConstr(13 * bill_hours + 20 * george_hours + 21 * jean_hours <= 129)
model.addConstr(13 * john_hours + 20 * mary_hours + 20 * george_hours <= 385)
model.addConstr(13 * john_hours + 20 * mary_hours + 13 * bill_hours + 20 * george_hours + 21 * jean_hours <= 385)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('\nCost: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

