
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define decision variables
john_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="john_hours")
mary_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary_hours")
bill_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bill_hours")
george_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george_hours")
jean_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean_hours")

# Objective function: Maximize total weighted hours
m.setObjective(4 * john_hours + 2 * mary_hours + bill_hours + 3 * george_hours + 9 * jean_hours, GRB.MAXIMIZE)

# Constraints based on likelihood to quit index for each individual and group requirements
# Note: For simplicity, 'x0', 'x1', etc., represent the coefficients in the natural language description.
m.addConstr(13 * john_hours >= 0)  # Not a real constraint but shows how one might be added
m.addConstr(20 * mary_hours >= 0)
m.addConstr(13 * bill_hours >= 0)
m.addConstr(20 * george_hours >= 0)
m.addConstr(21 * jean_hours >= 0)

# Constraints for minimum combined likelihood to quit index for various groups
m.addConstr((20 * mary_hours) + (20 * george_hours) + (21 * jean_hours) >= 68)
m.addConstr((13 * john_hours) + (20 * mary_hours) + (13 * bill_hours) >= 68)
m.addConstr((13 * john_hours) + (20 * george_hours) + (21 * jean_hours) >= 68)
m.addConstr((20 * mary_hours) + (13 * bill_hours) + (21 * jean_hours) >= 68)

# Additional constraints based on problem description
m.addConstr(-7 * john_hours + 7 * bill_hours >= 0)
m.addConstr(-10 * mary_hours - 3 * george_hours + 4 * jean_hours >= 0)

# Maximum combined likelihood to quit index for certain groups
m.addConstr((20 * mary_hours) + (13 * bill_hours) <= 124)
m.addConstr((13 * john_hours) + (20 * mary_hours) <= 340)
m.addConstr((13 * bill_hours) + (20 * george_hours) <= 86)
m.addConstr((13 * john_hours) + (20 * george_hours) <= 327)

# Solve the model
m.optimize()

# Print solution if found
if m.status == GRB.OPTIMAL:
    print("Solution found:")
    print(f"John Hours: {john_hours.x}")
    print(f"Mary Hours: {mary_hours.x}")
    print(f"Bill Hours: {bill_hours.x}")
    print(f"George Hours: {george_hours.x}")
    print(f"Jean Hours: {jean_hours.x}")
else:
    print("No solution found")
