
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
J = m.addVar(name="hours_worked_by_John", lb=0)
M = m.addVar(name="hours_worked_by_Mary", lb=0)
B = m.addVar(name="hours_worked_by_Bill", lb=0)
G = m.addVar(name="hours_worked_by_George", lb=0)
Je = m.addVar(name="hours_worked_by_Jean", lb=0)

# Objective function
m.setObjective(4 * J + 2 * M + 1 * B + 3 * G + 9 * Je, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(13 * J <= 401)
m.addConstr(20 * M <= 401)
m.addConstr(13 * B <= 401)
m.addConstr(20 * G <= 401)
m.addConstr(21 * Je <= 401)

m.addConstr(20 * M + 20 * G + 21 * Je >= 68)
m.addConstr(13 * J + 20 * M + 13 * B >= 68)
m.addConstr(13 * J + 20 * G + 21 * Je >= 68)
m.addConstr(20 * M + 13 * B + 21 * Je >= 68)
m.addConstr(13 * J + 13 * B + 20 * G >= 68)
m.addConstr(13 * J + 13 * B + 21 * Je >= 68)
m.addConstr(20 * M + 13 * B + 20 * G >= 68)

# Adding the rest of the constraints...
for i in range(9, 56):
    if i == 9:
        m.addConstr(20 * M + 20 * G + 21 * Je >= 65)
    elif i == 10:
        m.addConstr(13 * J + 20 * M + 13 * B >= 65)
    elif i == 11:
        m.addConstr(13 * J + 20 * G + 21 * Je >= 65)
    elif i == 12:
        m.addConstr(20 * M + 13 * B + 21 * Je >= 65)
    elif i == 13:
        m.addConstr(13 * J + 13 * B + 20 * G >= 65)
    elif i == 14:
        m.addConstr(13 * J + 13 * B + 21 * Je >= 65)
    elif i == 15:
        m.addConstr(20 * M + 13 * B + 20 * G >= 65)
    elif i == 16:
        m.addConstr(20 * M + 20 * G + 21 * Je >= 55)
    elif i == 17:
        m.addConstr(13 * J + 20 * M + 13 * B >= 55)
    elif i == 18:
        m.addConstr(13 * J + 20 * G + 21 * Je >= 55)
    elif i == 19:
        m.addConstr(20 * M + 13 * B + 21 * Je >= 55)
    elif i == 20:
        m.addConstr(13 * J + 13 * B + 20 * G >= 55)
    elif i == 21:
        m.addConstr(13 * J + 13 * B + 21 * Je >= 55)
    elif i == 22:
        m.addConstr(20 * M + 13 * B + 20 * G >= 55)
    elif i == 23:
        m.addConstr(20 * M + 20 * G + 21 * Je >= 49)
    elif i == 24:
        m.addConstr(13 * J + 20 * M + 13 * B >= 49)
    elif i == 25:
        m.addConstr(13 * J + 20 * G + 21 * Je >= 49)
    elif i == 26:
        m.addConstr(20 * M + 13 * B + 21 * Je >= 49)
    elif i == 27:
        m.addConstr(13 * J + 13 * B + 20 * G >= 49)
    elif i == 28:
        m.addConstr(13 * J + 13 * B + 21 * Je >= 49)
    elif i == 29:
        m.addConstr(20 * M + 13 * B + 20 * G >= 49)
    elif i == 30:
        m.addConstr(20 * M + 20 * G + 21 * Je >= 60)
    elif i == 31:
        m.addConstr(13 * J + 20 * M + 13 * B >= 60)
    elif i == 32:
        m.addConstr(13 * J + 20 * G + 21 * Je >= 60)
    elif i == 33:
        m.addConstr(20 * M + 13 * B + 21 * Je >= 60)
    elif i == 34:
        m.addConstr(13 * J + 13 * B + 20 * G >= 60)
    elif i == 35:
        m.addConstr(13 * J + 13 * B + 21 * Je >= 60)
    elif i == 36:
        m.addConstr(20 * M + 13 * B + 20 * G >= 60)
    elif i == 37:
        m.addConstr(20 * M + 20 * G + 21 * Je >= 75)
    elif i == 38:
        m.addConstr(13 * J + 20 * M + 13 * B >= 75)
    elif i == 39:
        m.addConstr(13 * J + 20 * G + 21 * Je >= 75)
    elif i == 40:
        m.addConstr(20 * M + 13 * B + 21 * Je >= 75)
    elif i == 41:
        m.addConstr(13 * J + 13 * B + 20 * G >= 75)
    elif i == 42:
        m.addConstr(13 * J + 13 * B + 21 * Je >= 75)
    elif i == 43:
        m.addConstr(20 * M + 13 * B + 20 * G >= 75)
    elif i == 44:
        m.addConstr(-7 * J + 7 * B >= 0)
    elif i == 45:
        m.addConstr(-10 * M - 3 * G + 4 * Je >= 0)
    elif i == 46:
        m.addConstr(20 * M + 13 * B <= 124)
    elif i == 47:
        m.addConstr(13 * J + 20 * M <= 340)
    elif i == 48:
        m.addConstr(13 * B + 20 * G <= 86)
    elif i == 49:
        m.addConstr(13 * J + 20 * G <= 327)
    elif i == 50:
        m.addConstr(20 * M + 13 * B + 21 * Je <= 124)
    elif i == 51:
        m.addConstr(13 * J + 20 * M + 13 * B <= 354)
    elif i == 52:
        m.addConstr(13 * J + 20 * M + 21 * Je <= 359)
    elif i == 53:
        m.addConstr(13 * J + 13 * B + 20 * G <= 226)
    elif i == 54:
        m.addConstr(13 * B + 20 * G + 21 * Je <= 129)
    elif i == 55:
        m.addConstr(13 * J + 20 * M + 20 * G <= 385)
    elif i == 56:
        m.addConstr(13 * J + 20 * M + 13 * B + 20 * G + 21 * Je <= 385)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", J.varValue)
    print("Hours worked by Mary: ", M.varValue)
    print("Hours worked by Bill: ", B.varValue)
    print("Hours worked by George: ", G.varValue)
    print("Hours worked by Jean: ", Je.varValue)
else:
    print("The model is infeasible")
