
from gurobipy import Model, GRB

# Define the model
model = Model("Vitamin Optimization")

# Define the variables
vitamin_b7 = model.addVar(vtype=GRB.INTEGER, name="vitamin_b7")
vitamin_c = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_c")
zinc = model.addVar(vtype=GRB.INTEGER, name="zinc")
vitamin_b5 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b5")
vitamin_b2 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b2")

# Define the objective function
model.setObjective(8.81 * vitamin_b7 + 1.33 * vitamin_c + 1.35 * zinc + 4.57 * vitamin_b5 + 5.85 * vitamin_b2, GRB.MINIMIZE)

# Define the resource constraints
resources = {
    'r0': {'upper_bound': 450, 'coefficients': [20, 27, 23, 27, 32]},  # energy stability index
    'r1': {'upper_bound': 242, 'coefficients': [25, 8, 11, 28, 16]},  # cardiovascular support index
    'r2': {'upper_bound': 531, 'coefficients': [13, 23, 19, 16, 11]},  # cognitive performance index
    'r3': {'upper_bound': 774, 'coefficients': [6, 13, 12, 22, 24]},  # kidney support index
    'r4': {'upper_bound': 645, 'coefficients': [27, 8, 29, 23, 32]},  # immune support index
}

for resource, data in resources.items():
    model.addConstr(
        data['coefficients'][0] * vitamin_b7 +
        data['coefficients'][1] * vitamin_c +
        data['coefficients'][2] * zinc +
        data['coefficients'][3] * vitamin_b5 +
        data['coefficients'][4] * vitamin_b2 <= data['upper_bound'],
        name=f"{resource}_constraint"
    )


# Add the other constraints as provided in the prompt, using the same structure as above.
# Example:
model.addConstr(23 * zinc + 32 * vitamin_b2 >= 87, "combined_energy_stability_1")
# ... (add all remaining constraints similarly)


# Solve the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vitamin B7: {vitamin_b7.x}")
    print(f"Vitamin C: {vitamin_c.x}")
    print(f"Zinc: {zinc.x}")
    print(f"Vitamin B5: {vitamin_b5.x}")
    print(f"Vitamin B2: {vitamin_b2.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

