
import gurobi as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
x0 = model.addVar(name="vitamin_B7", lb=0)  # milligrams of vitamin B7
x1 = model.addVar(name="vitamin_C", lb=0)  # milligrams of vitamin C
x2 = model.addVar(name="zinc", lb=0, integrality=1)  # milligrams of zinc
x3 = model.addVar(name="vitamin_B5", lb=0)  # milligrams of vitamin B5
x4 = model.addVar(name="vitamin_B2", lb=0)  # milligrams of vitamin B2

# Objective function
model.setObjective(8.81 * x0 + 1.33 * x1 + 1.35 * x2 + 4.57 * x3 + 5.85 * x4, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(20 * x0 + 27 * x1 + 23 * x2 + 27 * x3 + 32 * x4 <= 450, name="energy_stability_index")
model.addConstr(25 * x0 + 8 * x1 + 11 * x2 + 28 * x3 + 16 * x4 <= 242, name="cardiovascular_support_index")
model.addConstr(13 * x0 + 23 * x1 + 19 * x2 + 16 * x3 + 11 * x4 <= 531, name="cognitive_performance_index")
model.addConstr(6 * x0 + 13 * x1 + 12 * x2 + 22 * x3 + 24 * x4 <= 774, name="kidney_support_index")
model.addConstr(27 * x0 + 8 * x1 + 29 * x2 + 23 * x3 + 32 * x4 <= 645, name="immune_support_index")

model.addConstr(20 * x0 <= 450)
model.addConstr(27 * x1 <= 450)
model.addConstr(23 * x2 <= 450)
model.addConstr(27 * x3 <= 450)
model.addConstr(32 * x4 <= 450)

model.addConstr(25 * x0 + 8 * x1 + 11 * x2 + 28 * x3 + 16 * x4 >= 25)
model.addConstr(25 * x0 + 11 * x2 + 16 * x4 >= 41)
model.addConstr(13 * x0 + 23 * x1 >= 86)
model.addConstr(23 * x1 + 19 * x2 >= 84)
model.addConstr(19 * x2 + 11 * x4 >= 77)
model.addConstr(13 * x0 + 11 * x4 >= 61)

model.addConstr(8 * x0 - 7 * x3 >= 0)

model.addConstr(23 * x2 + 27 * x3 + 32 * x4 <= 231)
model.addConstr(20 * x0 + 27 * x3 + 32 * x4 <= 200)

model.optimize()

if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Vitamin B7: {x0.varValue}")
    print(f"Vitamin C: {x1.varValue}")
    print(f"Zinc: {x2.varValue}")
    print(f"Vitamin B5: {x3.varValue}")
    print(f"Vitamin B2: {x4.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
