
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
rubber_bands = model.addVar(vtype=GRB.INTEGER, name="rubber_bands")
monochrome_printers = model.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
cans_of_coffee = model.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")

# Set objective function
model.setObjective(5 * rubber_bands + 7 * monochrome_printers + 4 * cans_of_coffee, GRB.MINIMIZE)

# Add constraints
model.addConstr(19 * rubber_bands + 9 * cans_of_coffee >= 67, "c1")
model.addConstr(2 * monochrome_printers + 9 * cans_of_coffee >= 105, "c2")
model.addConstr(19 * rubber_bands + 2 * monochrome_printers >= 61, "c3")
model.addConstr(19 * rubber_bands + 2 * monochrome_printers + 9 * cans_of_coffee >= 67, "c4")
model.addConstr(-8 * rubber_bands + 5 * cans_of_coffee >= 0, "c5")
model.addConstr(-1 * monochrome_printers + 8 * cans_of_coffee >= 0, "c6")
model.addConstr(19 * rubber_bands + 9 * cans_of_coffee <= 311, "c7")
model.addConstr(19 * rubber_bands + 2 * monochrome_printers <= 174, "c8")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('rubber_bands:', rubber_bands.x)
    print('monochrome_printers:', monochrome_printers.x)
    print('cans_of_coffee:', cans_of_coffee.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', model.status)

