
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
rubber_bands = m.addVar(vtype=GRB.INTEGER, name="rubber_bands")
monochrome_printers = m.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
cans_of_coffee = m.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")

# Define the objective function
m.setObjective(5*rubber_bands + 7*monochrome_printers + 4*cans_of_coffee, GRB.MINIMIZE)

# Add constraints
m.addConstr(19*rubber_bands + 9*cans_of_coffee >= 67, name="usefulness_rubber_coffee")
m.addConstr(2*monochrome_printers + 9*cans_of_coffee >= 105, name="usefulness_printer_coffee")
m.addConstr(19*rubber_bands + 2*monochrome_printers >= 61, name="usefulness_rubber_printer")
m.addConstr(19*rubber_bands + 2*monochrome_printers + 9*cans_of_coffee >= 67, name="total_usefulness_min")
m.addConstr(-8*rubber_bands + 5*cans_of_coffee >= 0, name="rubber_coffee_constraint")
m.addConstr(-1*monochrome_printers + 8*cans_of_coffee >= 0, name="printer_coffee_constraint")
m.addConstr(19*rubber_bands + 9*cans_of_coffee <= 311, name="usefulness_rubber_coffee_max")
m.addConstr(19*rubber_bands + 2*monochrome_printers <= 174, name="usefulness_rubber_printer_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Rubber bands: {rubber_bands.x}")
    print(f"Monochrome printers: {monochrome_printers.x}")
    print(f"Cans of coffee: {cans_of_coffee.x}")
else:
    print("No optimal solution found.")

