
from gurobipy import *

# Create a model
m = Model("Work Hours")

# Define variables: Hours worked by each person
G = m.addVar(name='G', lb=0)  # George
J = m.addVar(name='J', lb=0)  # John
H = m.addVar(name='H', lb=0)  # Hank
B = m.addVar(name='B', lb=0)  # Bobby
M = m.addVar(name='M', lb=0)  # Mary
P = m.addVar(name='P', lb=0)  # Paul

# Objective: There is no clear objective function given, so we'll set it to minimize the total hours worked.
m.setObjective(G + J + H + B + M + P, GRB.MINIMIZE)

# Constraints
# Computer Competence Constraints
m.addConstr(2*G + 3*J - 4*H + 5*B + 6*M - 7*P >= 40)  # Example constraint for computer competence

# Organization Score Constraints
m.addConstr(G + J <= 91)

# Other constraints...
m.addConstr(H + B + P <= 141)
m.addConstr(J + H + B <= 138)
m.addConstr(2*G + 3*J <= 206)
m.addConstr(4*H + 5*B <= 280)
m.addConstr(G + M <= 136)
m.addConstr(G + B <= 332)
m.addConstr(G + H <= 168)
m.addConstr(B + P <= 455)
m.addConstr(J + M <= 450)
m.addConstr(H + P <= 376)
m.addConstr(J + H <= 161)
m.addConstr(J + B <= 167)
m.addConstr(M + P <= 264)

# Additional constraints based on given conditions...
m.addConstr(-6*G + 2*B >= 0)
m.addConstr(-6*B + 3*M >= 0)

# All variables are continuous
G.vType = GRB.CONTINUOUS
J.vType = GRB.CONTINUOUS
H.vType = GRB.CONTINUOUS
B.vType = GRB.CONTINUOUS
M.vType = GRB.CONTINUOUS
P.vType = GRB.CONTINUOUS

# Optimize the model
m.optimize()

