
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
hours_worked_by_George = model.addVar(lb=0, name="hours_worked_by_George", vtype=gurobi.GRB.CONTINUOUS)
hours_worked_by_John = model.addVar(lb=0, name="hours_worked_by_John", vtype=gurobi.GRB.CONTINUOUS)
hours_worked_by_Hank = model.addVar(lb=0, name="hours_worked_by_Hank", vtype=gurobi.GRB.CONTINUOUS)
hours_worked_by_Bobby = model.addVar(lb=0, name="hours_worked_by_Bobby", vtype=gurobi.GRB.CONTINUOUS)
hours_worked_by_Mary = model.addVar(lb=0, name="hours_worked_by_Mary", vtype=gurobi.GRB.CONTINUOUS)
hours_worked_by_Paul = model.addVar(lb=0, name="hours_worked_by_Paul", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(2 * hours_worked_by_George + 2 * hours_worked_by_John + 8 * hours_worked_by_Hank + 
                   hours_worked_by_Bobby + 2 * hours_worked_by_Mary + 5 * hours_worked_by_Paul, 
                   gurobi.GRB.MINIMIZE)

# Add constraints
# Organization score constraints
model.addConstr(14 * hours_worked_by_George >= 14, name="George_organization_score")
model.addConstr(7 * hours_worked_by_John >= 7, name="John_organization_score")
model.addConstr(1 * hours_worked_by_Hank >= 1, name="Hank_organization_score")
model.addConstr(6 * hours_worked_by_Bobby >= 6, name="Bobby_organization_score")
model.addConstr(1 * hours_worked_by_Mary >= 1, name="Mary_organization_score")
model.addConstr(6 * hours_worked_by_Paul >= 6, name="Paul_organization_score")

model.addConstr(14 * hours_worked_by_George + 6 * hours_worked_by_John >= 31, name="George_John_organization_score")
model.addConstr(7 * hours_worked_by_John + 14 * hours_worked_by_Hank >= 50, name="John_Hank_organization_score")
model.addConstr(1 * hours_worked_by_Hank + 6 * hours_worked_by_Bobby >= 49, name="Hank_Bobby_organization_score")
model.addConstr(14 * hours_worked_by_George + 1 * hours_worked_by_Hank >= 31, name="George_Hank_organization_score")
model.addConstr(7 * hours_worked_by_John + 6 * hours_worked_by_Paul >= 50, name="John_Paul_organization_score")
model.addConstr(7 * hours_worked_by_John + 1 * hours_worked_by_Hank >= 24, name="John_Hank_organization_score_2")
model.addConstr(14 * hours_worked_by_George + 7 * hours_worked_by_John >= 35, name="George_John_organization_score_2")
model.addConstr(1 * hours_worked_by_Hank + 1 * hours_worked_by_Mary + 6 * hours_worked_by_Paul >= 39, name="Hank_Mary_Paul_organization_score")

# Computer competence rating constraints
model.addConstr(6 * hours_worked_by_George + 1 * hours_worked_by_Mary >= 36, name="George_Mary_computer_competence")
model.addConstr(6 * hours_worked_by_John + 14 * hours_worked_by_Hank >= 59, name="John_Hank_computer_competence")
model.addConstr(6 * hours_worked_by_George + 5 * hours_worked_by_Hank >= 59, name="George_Hank_computer_competence")
model.addConstr(6 * hours_worked_by_George + 1 * hours_worked_by_Paul >= 50, name="George_Paul_computer_competence")
model.addConstr(14 * hours_worked_by_John + 1 * hours_worked_by_Mary >= 61, name="John_Mary_computer_competence")
model.addConstr(1 * hours_worked_by_Mary + 1 * hours_worked_by_Paul >= 48, name="Mary_Paul_computer_competence")
model.addConstr(6 * hours_worked_by_George + 14 * hours_worked_by_John >= 63, name="George_John_computer_competence")

# Other constraints
model.addConstr(-6 * hours_worked_by_George + 2 * hours_worked_by_Bobby >= 0, name="George_Bobby_constraint")
model.addConstr(-6 * hours_worked_by_Bobby + 3 * hours_worked_by_Mary >= 0, name="Bobby_Mary_constraint")
model.addConstr(14 * hours_worked_by_George + 7 * hours_worked_by_John <= 91, name="George_John_organization_score_max")
model.addConstr(1 * hours_worked_by_Hank + 6 * hours_worked_by_Bobby + 1 * hours_worked_by_Paul <= 141, name="Hank_Bobby_Paul_organization_score_max")
model.addConstr(7 * hours_worked_by_John + 1 * hours_worked_by_Hank + 6 * hours_worked_by_Bobby <= 138, name="John_Hank_Bobby_organization_score_max")

model.addConstr(6 * hours_worked_by_George + 14 * hours_worked_by_John <= 206, name="George_John_computer_competence_max")
model.addConstr(5 * hours_worked_by_Hank + 1 * hours_worked_by_Bobby <= 280, name="Hank_Bobby_computer_competence_max")
model.addConstr(6 * hours_worked_by_George + 1 * hours_worked_by_Mary <= 136, name="George_Mary_computer_competence_max")
model.addConstr(6 * hours_worked_by_George + 1 * hours_worked_by_Bobby <= 332, name="George_Bobby_computer_competence_max")
model.addConstr(6 * hours_worked_by_George + 5 * hours_worked_by_Hank <= 168, name="George_Hank_computer_competence_max")
model.addConstr(1 * hours_worked_by_Bobby + 1 * hours_worked_by_Paul <= 455, name="Bobby_Paul_computer_competence_max")
model.addConstr(14 * hours_worked_by_John + 1 * hours_worked_by_Mary <= 450, name="John_Mary_computer_competence_max")
model.addConstr(5 * hours_worked_by_Hank + 1 * hours_worked_by_Paul <= 376, name="Hank_Paul_computer_competence_max")
model.addConstr(6 * hours_worked_by_John + 14 * hours_worked_by_Hank <= 161, name="John_Hank_computer_competence_max")
model.addConstr(14 * hours_worked_by_John + 1 * hours_worked_by_Bobby <= 167, name="John_Bobby_computer_competence_max")
model.addConstr(1 * hours_worked_by_Mary + 1 * hours_worked_by_Paul <= 264, name="Mary_Paul_computer_competence_max")

# Solve the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by George: ", hours_worked_by_George.varValue)
    print("Hours worked by John: ", hours_worked_by_John.varValue)
    print("Hours worked by Hank: ", hours_worked_by_Hank.varValue)
    print("Hours worked by Bobby: ", hours_worked_by_Bobby.varValue)
    print("Hours worked by Mary: ", hours_worked_by_Mary.varValue)
    print("Hours worked by Paul: ", hours_worked_by_Paul.varValue)
    print("Objective function value: ", model.objVal)
else:
    print("No optimal solution found.")
