
from gurobipy import Model, GRB

# Create a new model
model = Model("carbohydrate_optimization")

# Create variables
lemons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lemons")
potatoes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
ravioli = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")
black_beans = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")

# Set objective function
model.setObjective(7.44 * lemons**2 + 5.02 * lemons * potatoes + 1.88 * lemons * ravioli + 2.78 * potatoes + 7.87 * ravioli + 8.79 * black_beans, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * potatoes**2 + 15 * ravioli**2 >= 29, "carbohydrate_constraint1")
model.addConstr(11 * lemons + 15 * ravioli >= 37, "carbohydrate_constraint2")
model.addConstr(15 * ravioli + 4 * black_beans <= 86, "carbohydrate_constraint3")
model.addConstr(20 * potatoes + 4 * black_beans <= 218, "carbohydrate_constraint4")
model.addConstr(11 * lemons**2 + 20 * potatoes**2 <= 185, "carbohydrate_constraint5")
model.addConstr(11 * lemons + 20 * potatoes + 15 * ravioli + 4 * black_beans <= 246, "carbohydrate_constraint6")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('lemons:', lemons.x)
    print('potatoes:', potatoes.x)
    print('ravioli:', ravioli.x)
    print('black_beans:', black_beans.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
