
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    lemons = model.addVar(lb=0, name="lemons", vtype=gurobi.GRB.CONTINUOUS)
    potatoes = model.addVar(lb=0, name="potatoes", vtype=gurobi.GRB.CONTINUOUS)
    ravioli = model.addVar(lb=0, name="ravioli", vtype=gurobi.GRB.CONTINUOUS)
    black_beans = model.addVar(lb=0, name="black_beans", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(7.44 * lemons**2 + 5.02 * lemons * potatoes + 1.88 * lemons * ravioli +
                       2.78 * potatoes + 7.87 * ravioli + 8.79 * black_beans, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(400 * potatoes**2 + 225 * ravioli**2 >= 29, name="potatoes_ravioli_squared")
    model.addConstr(11 * lemons + 15 * ravioli >= 37, name="lemons_ravioli_carb")
    model.addConstr(15 * ravioli + 4 * black_beans <= 86, name="ravioli_black_beans_carb")
    model.addConstr(20 * potatoes + 4 * black_beans <= 218, name="potatoes_black_beans_carb")
    model.addConstr(121 * lemons**2 + 400 * potatoes**2 <= 185, name="lemons_potatoes_squared_carb")
    model.addConstr(11 * lemons + 20 * potatoes + 15 * ravioli + 4 * black_beans <= 185, name="total_carb")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Lemons: {lemons.varValue}")
        print(f"Potatoes: {potatoes.varValue}")
        print(f"Ravioli: {ravioli.varValue}")
        print(f"Black Beans: {black_beans.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
