
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lemons = m.addVar(lb=0, name="lemons")
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
cherry_pies = m.addVar(lb=0, name="cherry_pies")
fruit_salads = m.addVar(lb=0, name="fruit_salads")

# Set objective function
m.setObjective(7.26 * lemons + 6.62 * ham_sandwiches + 1.42 * cherry_pies + 2.56 * fruit_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5.8 * lemons + 8.4 * fruit_salads >= 27, "c1")
m.addConstr(2.9 * cherry_pies + 8.4 * fruit_salads >= 37, "c2")
m.addConstr(3.85 * ham_sandwiches + 8.4 * fruit_salads >= 30, "c3")
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies >= 31, "c4")
m.addConstr(5.8 * lemons + 2.9 * cherry_pies + 8.4 * fruit_salads >= 31, "c5")
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies >= 41, "c6")
m.addConstr(5.8 * lemons + 2.9 * cherry_pies + 8.4 * fruit_salads >= 41, "c7")
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies + 8.4 * fruit_salads >= 41, "c8")

m.addConstr(5.15 * lemons + 7.62 * fruit_salads >= 27, "c9")
m.addConstr(5.15 * lemons + 3.63 * ham_sandwiches >= 24, "c10")
m.addConstr(3.3 * cherry_pies + 7.62 * fruit_salads >= 47, "c11")
m.addConstr(3.63 * ham_sandwiches + 3.3 * cherry_pies >= 38, "c12")
m.addConstr(5.15 * lemons + 3.3 * cherry_pies + 7.62 * fruit_salads >= 32, "c13")
m.addConstr(5.15 * lemons + 3.63 * ham_sandwiches + 3.3 * cherry_pies + 7.62 * fruit_salads >= 32, "c14")

m.addConstr(-6 * cherry_pies + 7 * fruit_salads >= 0, "c15")
m.addConstr(2 * ham_sandwiches - cherry_pies >= 0, "c16")

m.addConstr(5.8 * lemons + 2.9 * cherry_pies <= 130, "c17")
m.addConstr(2.9 * cherry_pies + 8.4 * fruit_salads <= 169, "c18")
m.addConstr(3.85 * ham_sandwiches + 2.9 * cherry_pies <= 181, "c19")
m.addConstr(3.85 * ham_sandwiches + 8.4 * fruit_salads <= 73, "c20")
m.addConstr(5.15 * lemons + 3.3 * cherry_pies + 7.62 * fruit_salads <= 68, "c21")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

