
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
lemons = m.addVar(name="lemons", lb=0)  # No lower bound specified, assuming 0
ham_sandwiches = m.addVar(name="ham_sandwiches", lb=0)  # No lower bound specified, assuming 0
cherry_pies = m.addVar(name="cherry_pies", lb=0)  # No lower bound specified, assuming 0
fruit_salads = m.addVar(name="fruit_salads", lb=0)  # No lower bound specified, assuming 0

# Define the objective function
m.setObjective(7.26 * lemons + 6.62 * ham_sandwiches + 1.42 * cherry_pies + 2.56 * fruit_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5.8 * lemons + 8.4 * fruit_salads >= 27)
m.addConstr(2.9 * cherry_pies + 8.4 * fruit_salads >= 37)
m.addConstr(3.85 * ham_sandwiches + 8.4 * fruit_salads >= 30)
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies >= 31)
m.addConstr(5.8 * lemons + 2.9 * cherry_pies + 8.4 * fruit_salads >= 31)
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies >= 41)
m.addConstr(5.8 * lemons + 2.9 * cherry_pies + 8.4 * fruit_salads >= 41)
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies + 8.4 * fruit_salads >= 41)
m.addConstr(5.15 * lemons + 7.62 * fruit_salads >= 27)
m.addConstr(5.15 * lemons + 3.63 * ham_sandwiches >= 24)
m.addConstr(3.3 * cherry_pies + 7.62 * fruit_salads >= 47)
m.addConstr(3.63 * ham_sandwiches + 3.3 * cherry_pies >= 38)
m.addConstr(5.15 * lemons + 3.3 * cherry_pies + 7.62 * fruit_salads >= 32)
m.addConstr(5.15 * lemons + 3.63 * ham_sandwiches + 3.3 * cherry_pies + 7.62 * fruit_salads >= 32)
m.addConstr(-6 * cherry_pies + 7 * fruit_salads >= 0)
m.addConstr(2 * ham_sandwiches - cherry_pies >= 0)
m.addConstr(5.8 * lemons + 2.9 * cherry_pies <= 130)
m.addConstr(2.9 * cherry_pies + 8.4 * fruit_salads <= 169)
m.addConstr(3.85 * ham_sandwiches + 2.9 * cherry_pies <= 181)
m.addConstr(3.85 * ham_sandwiches + 8.4 * fruit_salads <= 73)
m.addConstr(5.15 * lemons + 3.3 * cherry_pies + 7.62 * fruit_salads <= 68)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Lemons: ", lemons.varValue)
    print("Ham sandwiches: ", ham_sandwiches.varValue)
    print("Cherry pies: ", cherry_pies.varValue)
    print("Fruit salads: ", fruit_salads.varValue)
else:
    print("The model is infeasible")
