
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(lb=0, name="steaks")
bacon = m.addVar(lb=0, name="bacon")
sashimi = m.addVar(lb=0, name="sashimi")
green_beans = m.addVar(lb=0, name="green_beans")

# Set objective function
m.setObjective(1.91 * steaks + 5.34 * bacon + 5.06 * sashimi + 9.14 * green_beans, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * steaks + 6 * green_beans >= 19, "c0")
m.addConstr(6 * bacon + 6 * green_beans >= 30, "c1")
m.addConstr(8 * steaks + 7 * sashimi >= 47, "c2")
m.addConstr(6 * bacon + 7 * sashimi >= 21, "c3")
m.addConstr(8 * steaks + 6 * bacon + 7 * sashimi >= 41, "c4")
m.addConstr(8 * steaks + 6 * bacon + 7 * sashimi + 6 * green_beans >= 41, "c5")
m.addConstr(7 * bacon + 10 * sashimi >= 34, "c6")
m.addConstr(10 * sashimi + 14 * green_beans >= 35, "c7")
m.addConstr(7 * bacon + 14 * green_beans >= 20, "c8")
m.addConstr(7 * steaks + 7 * bacon + 10 * sashimi + 14 * green_beans >= 20, "c9")
m.addConstr(6 * sashimi + 15 * green_beans >= 17, "c10")
m.addConstr(16 * steaks + 7 * bacon >= 45, "c11")
m.addConstr(16 * steaks + 7 * bacon + 6 * sashimi + 15 * green_beans >= 45, "c12")
m.addConstr(-6 * sashimi + 5 * green_beans >= 0, "c13")

# Resource Constraints
m.addConstr(8 * steaks + 6 * bacon + 7 * sashimi + 6 * green_beans <= 195, "r0")
m.addConstr(7 * steaks + 7 * bacon + 10 * sashimi + 14 * green_beans <= 178, "r1")
m.addConstr(16 * steaks + 7 * bacon + 6 * sashimi + 15 * green_beans <= 205, "r2")


# Additional upper bound constraints
m.addConstr(7 * sashimi + 6 * green_beans <= 101, "c14")
m.addConstr(8 * steaks + 6 * green_beans <= 160, "c15")
m.addConstr(8 * steaks + 7 * sashimi + 6 * green_beans <= 142, "c16")
m.addConstr(6 * bacon + 7 * sashimi + 6 * green_beans <= 78, "c17")
m.addConstr(8 * steaks + 6 * bacon + 6 * green_beans <= 77, "c18")
m.addConstr(16 * steaks + 6 * sashimi <= 147, "c19")
m.addConstr(16 * steaks + 7 * bacon <= 126, "c20")
m.addConstr(6 * sashimi + 15 * green_beans <= 124, "c21")
m.addConstr(7 * bacon + 15 * green_beans <= 180, "c22")
m.addConstr(7 * bacon + 6 * sashimi <= 143, "c23")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

