
from gurobipy import Model, GRB

# Create a new model
m = Model("minimize_cost")

# Create variables
paper_towels = m.addVar(vtype=GRB.INTEGER, name="paper_towels")
lightbulbs = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")

# Set objective function
m.setObjective(9.45 * paper_towels + 4.16 * lightbulbs, GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * paper_towels + 28 * lightbulbs >= 93, "value_min")
m.addConstr(9 * paper_towels - 7 * lightbulbs >= 0, "quantity_relation")
m.addConstr(19 * paper_towels + 28 * lightbulbs <= 114, "value_max")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Paper Towel Rolls: {paper_towels.x}")
    print(f"Lightbulbs: {lightbulbs.x}")
    print(f"Objective Value: {m.objVal}")

