
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
paper_towel_rolls = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")
lightbulbs = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")

# Objective function: Minimize 9.45 * paper_towel_rolls + 4.16 * lightbulbs
m.setObjective(9.45 * paper_towel_rolls + 4.16 * lightbulbs, GRB.MINIMIZE)

# Constraints
# 1. Total value of paper towel rolls and lightbulbs is at least $93
m.addConstr(19 * paper_towel_rolls + 28 * lightbulbs >= 93, name="min_total_value")

# 2. The specific linear combination constraint
m.addConstr(9 * paper_towel_rolls - 7 * lightbulbs >= 0, name="linear_combination")

# 3. Combined value cannot exceed $219 (corrected understanding of the upper bound)
m.addConstr(19 * paper_towel_rolls + 28 * lightbulbs <= 219, name="max_total_value")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Paper towel rolls: {paper_towel_rolls.x}")
    print(f"Lightbulbs: {lightbulbs.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
