
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER, lb=0)
    x1 = model.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Minimize 9.45*x0 + 4.16*x1
    model.setObjective(9.45 * x0 + 4.16 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(19 * x0 + 28 * x1 >= 93, name="total_value_min")
    model.addConstr(9 * x0 - 7 * x1 >= 0, name="product_constraint")
    model.addConstr(19 * x0 + 28 * x1 <= 114, name="total_value_max")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Paper Towel Rolls: {x0.varValue}")
        print(f"Lightbulbs: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
