
from gurobipy import Model, GRB

# Create a new model
model = Model("Supplement_Optimization")

# Create variables
calcium = model.addVar(vtype=GRB.INTEGER, name="calcium")
zinc = model.addVar(vtype=GRB.CONTINUOUS, name="zinc")
vitamin_c = model.addVar(vtype=GRB.INTEGER, name="vitamin_c")

# Set objective function
model.setObjective(2.57 * calcium**2 + 9.67 * calcium * zinc + 5.9 * zinc**2 + 1.07 * vitamin_c**2 + 5.17 * calcium, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * calcium + 3 * zinc + 3 * vitamin_c <= 50, "r0_upper_bound")  # Kidney support index
model.addConstr(2 * calcium + 8 * zinc + 5 * vitamin_c <= 106, "r1_upper_bound") # Muscle growth index
model.addConstr(11 * calcium + 11 * zinc + 9 * vitamin_c <= 81, "r2_upper_bound") # Cardiovascular support index

model.addConstr(3 * zinc**2 + 3 * vitamin_c**2 >= 8, "kidney_zinc_vitamin_c_lower")
model.addConstr(1 * calcium**2 + 3 * vitamin_c**2 >= 10, "kidney_calcium_vitamin_c_lower")
model.addConstr(1 * calcium + 3 * zinc + 3 * vitamin_c >= 15, "kidney_total_lower")

model.addConstr(2 * calcium**2 + 8 * zinc**2 >= 32, "muscle_calcium_zinc_lower")
model.addConstr(11 * calcium**2 + 9 * vitamin_c**2 >= 13, "cardio_calcium_vitamin_c_lower")

model.addConstr(3 * zinc**2 + 3 * vitamin_c**2 <= 19, "kidney_zinc_vitamin_c_upper")
model.addConstr(1 * calcium + 3 * zinc <= 40, "kidney_calcium_zinc_upper")
model.addConstr(1 * calcium + 3 * zinc + 3 * vitamin_c <= 40, "kidney_total_upper")

model.addConstr(2 * calcium**2 + 8 * zinc**2 <= 55, "muscle_calcium_zinc_upper")
model.addConstr(2 * calcium**2 + 5 * vitamin_c**2 <= 79, "muscle_calcium_vitamin_c_upper")
model.addConstr(2 * calcium + 8 * zinc + 5 * vitamin_c <= 79, "muscle_total_upper")

model.addConstr(11 * calcium + 9 * vitamin_c <= 54, "cardio_calcium_vitamin_c_upper")
model.addConstr(11 * calcium + 11 * zinc + 9 * vitamin_c <= 54, "cardio_total_upper")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('calcium:', calcium.x)
    print('zinc:', zinc.x)
    print('vitamin_c:', vitamin_c.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

