
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="calcium", vtype=gp.GRB.INTEGER)  # milligrams of calcium
x1 = m.addVar(name="zinc", vtype=gp.GRB.CONTINUOUS)  # milligrams of zinc
x2 = m.addVar(name="vitamin_C", vtype=gp.GRB.INTEGER)  # milligrams of vitamin C

# Define the objective function
m.setObjective(2.57*x0**2 + 9.67*x0*x1 + 5.9*x1**2 + 1.07*x2**2 + 5.17*x0, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(1*x0 <= 50, name="kidney_support_calcium")
m.addConstr(2*x0 <= 106, name="muscle_growth_calcium")
m.addConstr(11*x0 <= 81, name="cardiovascular_support_calcium")

m.addConstr(3*x1 <= 50, name="kidney_support_zinc")
m.addConstr(8*x1 <= 106, name="muscle_growth_zinc")
m.addConstr(11*x1 <= 81, name="cardiovascular_support_zinc")

m.addConstr(3*x2 <= 50, name="kidney_support_vitamin_C")
m.addConstr(5*x2 <= 106, name="muscle_growth_vitamin_C")
m.addConstr(9*x2 <= 81, name="cardiovascular_support_vitamin_C")

m.addConstr(3*x1**2 + 3*x2**2 >= 8, name="kidney_support_zinc_vitamin_C")
m.addConstr(x0**2 + 3*x2**2 >= 10, name="kidney_support_calcium_vitamin_C")
m.addConstr(x0 + 3*x1 + 3*x2 >= 15, name="kidney_support_all")

m.addConstr(2*x0**2 + 8*x1**2 >= 32, name="muscle_growth_calcium_zinc")
m.addConstr(11*x0**2 + 9*x2**2 >= 13, name="cardiovascular_support_calcium_vitamin_C")

m.addConstr(3*x1**2 + 3*x2**2 <= 19, name="kidney_support_zinc_vitamin_C_max")
m.addConstr(x0 + 3*x1 <= 40, name="kidney_support_calcium_zinc")
m.addConstr(x0 + 3*x1 + 3*x2 <= 40, name="kidney_support_all_max")

m.addConstr(2*x0**2 + 8*x1**2 <= 55, name="muscle_growth_calcium_zinc_max")
m.addConstr(2*x0**2 + 5*x2**2 <= 79, name="muscle_growth_calcium_vitamin_C_max")
m.addConstr(2*x0 + 8*x1 + 5*x2 <= 79, name="muscle_growth_all_max")

m.addConstr(11*x0 + 9*x2 <= 54, name="cardiovascular_support_calcium_vitamin_C_max")
m.addConstr(11*x0 + 11*x1 + 9*x2 <= 54, name="cardiovascular_support_all_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of calcium: {x0.varValue}")
    print(f"Milligrams of zinc: {x1.varValue}")
    print(f"Milligrams of vitamin C: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
