
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
cafeteria_chairs = m.addVar(vtype=GRB.INTEGER, name="cafeteria_chairs")
black_pens = m.addVar(vtype=GRB.INTEGER, name="black_pens")
usb_flash_drives = m.addVar(vtype=GRB.INTEGER, name="usb_flash_drives")

# Set objective function
m.setObjective(7 * cafeteria_chairs + 8 * black_pens + 4 * usb_flash_drives, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * cafeteria_chairs + 12 * black_pens <= 51, "c1")  # Sustainability score for chairs and pens
m.addConstr(9 * cafeteria_chairs + 12 * black_pens + 8 * usb_flash_drives <= 51, "c2")  # Total sustainability score
m.addConstr(1 * cafeteria_chairs + 1 * usb_flash_drives <= 35, "c3")  # Cost of chairs and drives
m.addConstr(1 * black_pens + 1 * usb_flash_drives <= 67, "c4")  # Cost of pens and drives
m.addConstr(1 * cafeteria_chairs + 1 * black_pens + 1 * usb_flash_drives <= 67, "c5")  # Total cost


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cafeteria_chairs:', cafeteria_chairs.x)
    print('black_pens:', black_pens.x)
    print('usb_flash_drives:', usb_flash_drives.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

