
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="cafeteria_chairs")
x1 = m.addVar(vtype=GRB.INTEGER, name="black_pens")
x2 = m.addVar(vtype=GRB.INTEGER, name="usb_flash_drives")

# Set the objective function
m.setObjective(7*x0 + 8*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*x0 + 12*x1 + 8*x2 <= 125, "Sustainability_Score_Constraint")
m.addConstr(x0 + x1 + x2 <= 67, "Total_Cost_Constraint")
m.addConstr(x1 + x2 <= 67, "Black_Pens_and_USB_Flash_Drives_Cost_Constraint")
m.addConstr(x0 + x2 <= 35, "Cafeteria_Chairs_and_USB_Flash_Drives_Cost_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cafeteria Chairs: {x0.x}")
    print(f"Black Pens: {x1.x}")
    print(f"USB Flash Drives: {x2.x}")
else:
    print("No optimal solution found.")
