
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    cafeteria_chairs = model.addVar(name="cafeteria_chairs", vtype=gurobi.GRB.INTEGER)
    black_pens = model.addVar(name="black_pens", vtype=gurobi.GRB.INTEGER)
    usb_flash_drives = model.addVar(name="usb_flash_drives", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7 * cafeteria_chairs + 8 * black_pens + 4 * usb_flash_drives, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Sustainability score for cafeteria chairs and black pens
    model.addConstr(9 * cafeteria_chairs + 12 * black_pens <= 51, name="sustainability_score_cc_bp")

    # Sustainability score for all items
    model.addConstr(9 * cafeteria_chairs + 12 * black_pens + 8 * usb_flash_drives <= 51, name="sustainability_score_all")

    # Cost constraint for cafeteria chairs and usb flash drives
    model.addConstr(cafeteria_chairs + usb_flash_drives <= 35, name="cost_cc_ufd")

    # Cost constraint for black pens and usb flash drives
    model.addConstr(black_pens + usb_flash_drives <= 67, name="cost_bp_ufd")

    # Cost constraint for all items
    model.addConstr(cafeteria_chairs + black_pens + usb_flash_drives <= 67, name="cost_all")

    # Non-negativity constraints (implicit for integer variables)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cafeteria Chairs: {cafeteria_chairs.varValue}")
        print(f"Black Pens: {black_pens.varValue}")
        print(f"USB Flash Drives: {usb_flash_drives.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
