
from gurobipy import *

# Create a model
m = Model("Optimization Problem")

# Define decision variables
R = m.addVar(name='Ringo', lb=0)  # Hours worked by Ringo
J = m.addVar(name='Jean', lb=0)   # Hours worked by Jean
H = m.addVar(name='Hank', lb=0)   # Hours worked by Hank
G = m.addVar(name='George', lb=0) # Hours worked by George
L = m.addVar(name='Laura', lb=0)  # Hours worked by Laura
B = m.addVar(name='Bobby', lb=0)  # Hours worked by Bobby

# Add constraints based on the problem statement
m.addConstr(R - B >= 0, name='Ringo vs. Bobby')
m.addConstr(238 >= R + H, name='Ringo and Hank Computer Competence')
m.addConstr(R + B <= 174, name='Ringo and Bobby Computer Competence')
m.addConstr(G + B <= 192, name='George and Bobby Computer Competence')

# Example constraint for dollar cost per hour
m.addConstr(L * 397 + B * 397 <= 397, name='Laura and Bobby Dollar Cost Per Hour')

# Add more constraints here based on the provided requirements...

# Objective function - For demonstration, let's minimize the total hours worked
m.setObjective(R + J + H + G + L + B, GRB.MINIMIZE)

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f'{v.varName}: {v.x}')

print('Obj:', m.objVal)
