
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
R = m.addVar(lb=0, name="Ringo")
J = m.addVar(lb=0, name="Jean")
H = m.addVar(lb=0, name="Hank")
G = m.addVar(lb=0, name="George")
L = m.addVar(lb=0, name="Laura")
B = m.addVar(lb=0, name="Bobby")

# Define the objective function
m.setObjective(2*R + 4*J + H + 2*G + 8*L + 6*B, gp.GRB.MINIMIZE)

# Add constraints
# Computer competence rating constraints
m.addConstr(15.73*R + 4.24*J >= 40)
m.addConstr(15.73*R + 12.37*L >= 28)
m.addConstr(4.24*J + 12.37*L >= 21)
m.addConstr(13.87*H + 13.37*B >= 58)
m.addConstr(3.38*G + 13.37*B >= 46)
m.addConstr(13.87*H + 3.38*G >= 30)
m.addConstr(15.73*R + 3.38*G >= 29)
m.addConstr(4.24*J + 3.38*G >= 61)
m.addConstr(13.87*H + 12.37*L >= 42)
m.addConstr(15.73*R + 13.87*H >= 21)
m.addConstr(4.24*J + 13.87*H + 3.38*G >= 43)
m.addConstr(13.87*H + 12.37*L + 13.37*B >= 43)
m.addConstr(4.24*J + 13.87*H + 12.37*L >= 43)
m.addConstr(15.73*R + 12.37*L + 13.37*B >= 43)
m.addConstr(4.24*J + 13.87*H + 13.37*B >= 43)
m.addConstr(15.73*R + 4.24*J + 3.38*G >= 43)
m.addConstr(15.73*R + 13.87*H + 3.38*G >= 43)
m.addConstr(4.24*J + 3.38*G + 13.37*B >= 43)
m.addConstr(4.24*J + 12.37*L + 13.37*B >= 43)
m.addConstr(3.38*G + 12.37*L + 13.37*B >= 43)
m.addConstr(15.73*R + 3.38*G + 12.37*L >= 43)

# Productivity rating constraints
m.addConstr(5*R + 9.14*G + 3.59*L >= 44)
m.addConstr(9.14*G + 16.66*B >= 40)
m.addConstr(16.3*H + 16.66*B >= 43)
m.addConstr(16.3*H + 9.14*G >= 65)
m.addConstr(5*R + 16.3*H + 3.59*L >= 73)
m.addConstr(5*R + 7.79*J + 9.14*G >= 73)
m.addConstr(16.3*H + 9.14*G + 16.66*B >= 73)
m.addConstr(5*R + 3.59*L + 16.66*B >= 73)
m.addConstr(7.79*J + 3.59*L + 16.66*B >= 73)
m.addConstr(16.3*H + 9.14*G + 3.59*L >= 73)
m.addConstr(7.79*J + 16.3*H + 16.66*B >= 73)

# Dollar cost per hour and paperwork competence rating constraints
m.addConstr(10.69*R + 17.9*B >= 0)
# ... (rest of the constraints)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ringo: ", R.varValue)
    print("Jean: ", J.varValue)
    print("Hank: ", H.varValue)
    print("George: ", G.varValue)
    print("Laura: ", L.varValue)
    print("Bobby: ", B.varValue)
else:
    print("No optimal solution found")
