
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
protein_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
pizza_slices = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pizza_slices")
black_beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="black_beans")
corn_cobs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")

# Set objective function
m.setObjective(9 * protein_bars + 4 * pizza_slices + 2 * black_beans + 1 * corn_cobs, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.77 * protein_bars + 1.91 * pizza_slices + 1.24 * black_beans + 3.87 * corn_cobs <= 332, "r0_sourness_index")
m.addConstr(2.27 * protein_bars + 1.67 * pizza_slices + 2.46 * black_beans + 2.47 * corn_cobs <= 72, "r1_dollar_cost")
m.addConstr(3.21 * protein_bars + 2.47 * pizza_slices + 2.12 * black_beans + 3.44 * corn_cobs <= 302, "r2_iron")
m.addConstr(0.91 * protein_bars + 1.22 * pizza_slices + 0.06 * black_beans + 1.77 * corn_cobs <= 304, "r3_fiber")

m.addConstr(0.77 * protein_bars + 1.24 * black_beans >= 83, "sourness_pb_bb_min")
m.addConstr(0.77 * protein_bars + 3.87 * corn_cobs >= 72, "sourness_pb_cc_min")
m.addConstr(2.27 * protein_bars + 1.67 * pizza_slices >= 17, "cost_pb_ps_min")
m.addConstr(1.67 * pizza_slices + 2.46 * black_beans >= 15, "cost_ps_bb_min")
m.addConstr(3.21 * protein_bars + 2.47 * pizza_slices >= 65, "iron_pb_ps_min")
m.addConstr(2.47 * pizza_slices + 2.12 * black_beans >= 54, "iron_ps_bb_min")
m.addConstr(3.21 * protein_bars + 3.44 * corn_cobs >= 66, "iron_pb_cc_min")
m.addConstr(3.21 * protein_bars + 2.12 * black_beans >= 35, "iron_pb_bb_min")
m.addConstr(2.12 * black_beans + 3.44 * corn_cobs >= 43, "iron_bb_cc_min")
m.addConstr(3.21 * protein_bars + 2.12 * black_beans + 3.44 * corn_cobs >= 64, "iron_pb_bb_cc_min")
m.addConstr(0.91 * protein_bars + 1.77 * corn_cobs >= 55, "fiber_pb_cc_min")
m.addConstr(0.91 * protein_bars + 0.06 * black_beans >= 69, "fiber_pb_bb_min")
m.addConstr(0.91 * protein_bars + 1.22 * pizza_slices >= 54, "fiber_pb_ps_min")
m.addConstr(1.22 * pizza_slices + 1.77 * corn_cobs >= 61, "fiber_ps_cc_min")
m.addConstr(1.22 * pizza_slices + 0.06 * black_beans >= 46, "fiber_ps_bb_min")

m.addConstr(1.24 * black_beans + 3.87 * corn_cobs <= 213, "sourness_bb_cc_max")
m.addConstr(0.77 * protein_bars + 3.87 * corn_cobs <= 159, "sourness_pb_cc_max")
m.addConstr(0.77 * protein_bars + 1.24 * black_beans <= 198, "sourness_pb_bb_max")
m.addConstr(1.91 * pizza_slices + 3.87 * corn_cobs <= 300, "sourness_ps_cc_max")
m.addConstr(0.77 * protein_bars + 1.91 * pizza_slices <= 240, "sourness_pb_ps_max")
m.addConstr(0.77 * protein_bars + 1.91 * pizza_slices + 1.24 * black_beans + 3.87 * corn_cobs <= 240, "sourness_total_max")

m.addConstr(2.27 * protein_bars + 2.47 * corn_cobs <= 28, "cost_pb_cc_max")
m.addConstr(1.67 * pizza_slices + 2.46 * black_beans <= 36, "cost_ps_bb_max")
m.addConstr(2.46 * black_beans + 2.47 * corn_cobs <= 26, "cost_bb_cc_max")
m.addConstr(1.67 * pizza_slices + 2.47 * corn_cobs <= 65, "cost_ps_cc_max")
m.addConstr(2.27 * protein_bars + 1.67 * pizza_slices + 2.46 * black_beans + 2.47 * corn_cobs <= 65, "cost_total_max")


m.addConstr(2.12 * black_beans + 3.44 * corn_cobs <= 211, "iron_bb_cc_max")
m.addConstr(3.21 * protein_bars + 2.12 * black_beans <= 284, "iron_pb_bb_max")
m.addConstr(3.21 * protein_bars + 2.47 * pizza_slices <= 153, "iron_pb_ps_max")
m.addConstr(2.47 * pizza_slices + 2.12 * black_beans <= 139, "iron_ps_bb_max")
m.addConstr(3.21 * protein_bars + 2.47 * pizza_slices + 3.44 * corn_cobs <= 135, "iron_pb_ps_cc_max")
m.addConstr(3.21 * protein_bars + 2.47 * pizza_slices + 2.12 * black_beans <= 175, "iron_pb_ps_bb_max")
m.addConstr(3.21 * protein_bars + 2.47 * pizza_slices + 2.12 * black_beans + 3.44 * corn_cobs <= 175, "iron_total_max")

m.addConstr(1.22 * pizza_slices + 1.77 * corn_cobs <= 304, "fiber_ps_cc_max")
m.addConstr(0.06 * black_beans + 1.77 * corn_cobs <= 101, "fiber_bb_cc_max")
m.addConstr(0.91 * protein_bars + 1.77 * corn_cobs <= 280, "fiber_pb_cc_max")
m.addConstr(1.22 * pizza_slices + 0.06 * black_beans + 1.77 * corn_cobs <= 303, "fiber_ps_bb_cc_max")
m.addConstr(0.91 * protein_bars + 0.06 * black_beans + 1.77 * corn_cobs <= 147, "fiber_pb_bb_cc_max")
m.addConstr(0.91 * protein_bars + 1.22 * pizza_slices + 0.06 * black_beans + 1.77 * corn_cobs <= 147, "fiber_total_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

