
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
potassium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="potassium")

# Set objective function
m.setObjective(7 * calcium + 5 * potassium, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * calcium + 4 * potassium >= 18, "kidney_support_min")
m.addConstr(1 * calcium + 7 * potassium >= 31, "energy_stability_min")
m.addConstr(4 * calcium + 4 * potassium >= 36, "digestive_support_min")
m.addConstr(12 * calcium + 7 * potassium >= 26, "cognitive_performance_min")
m.addConstr(1 * calcium - 6 * potassium >= 0, "calcium_potassium_ratio")

m.addConstr(8 * calcium + 4 * potassium <= 97, "kidney_support_max")
m.addConstr(1 * calcium + 7 * potassium <= 120, "energy_stability_max")
m.addConstr(4 * calcium + 4 * potassium <= 62, "digestive_support_max")
m.addConstr(12 * calcium + 7 * potassium <= 102, "cognitive_performance_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Milligrams of Calcium: {calcium.x}")
    print(f"  Milligrams of Potassium: {potassium.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

