
import gurobi as gp

# Create a new model
model = gp.Model("optimization_problem")

# Define the variables
x0 = model.addVar(name="milligrams_of_calcium", lb=0)  # Can be a non-whole number
x1 = model.addVar(name="milligrams_of_potassium", lb=0, type=gp.GRB.INTEGER)  # Must be a whole number

# Define the objective function
model.setObjective(7 * x0 + 5 * x1, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * x0 + 4 * x1 >= 18, name="kidney_support_index")
model.addConstr(x0 + 7 * x1 >= 31, name="energy_stability_index")
model.addConstr(4 * x0 + 4 * x1 >= 36, name="digestive_support_index")
model.addConstr(12 * x0 + 7 * x1 >= 26, name="cognitive_performance_index")
model.addConstr(x0 - 6 * x1 >= 0, name="calcium_potassium_relation")

model.addConstr(8 * x0 + 4 * x1 <= 97, name="kidney_support_index_upper_bound")
model.addConstr(x0 + 7 * x1 <= 120, name="energy_stability_index_upper_bound")
model.addConstr(4 * x0 + 4 * x1 <= 62, name="digestive_support_index_upper_bound")
model.addConstr(12 * x0 + 7 * x1 <= 102, name="cognitive_performance_index_upper_bound")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of calcium: {x0.varValue}")
    print(f"Milligrams of potassium: {x1.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
