
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b5 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
zinc = m.addVar(vtype=gp.GRB.CONTINUOUS, name="zinc")
vitamin_b7 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b4 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
calcium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="calcium")

# Set objective function
m.setObjective(5.81 * vitamin_b5 + 4.93 * zinc + 5.73 * vitamin_b7 + 8.21 * vitamin_b4 + 8.07 * calcium, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * vitamin_b5 + 20 * zinc + 31 * vitamin_b7 >= 69, "c1")
m.addConstr(5 * vitamin_b5 + 20 * zinc + 14 * vitamin_b4 >= 69, "c2")
m.addConstr(5 * vitamin_b5 + 20 * zinc + 31 * vitamin_b7 >= 80, "c3")
m.addConstr(5 * vitamin_b5 + 20 * zinc + 14 * vitamin_b4 >= 80, "c4")
m.addConstr(5 * vitamin_b5 + 31 * calcium <= 486, "c5")
m.addConstr(20 * zinc + 31 * vitamin_b7 <= 213, "c6")
m.addConstr(5 * vitamin_b5 + 20 * zinc + 31 * vitamin_b7 + 14 * vitamin_b4 + 31 * calcium <= 213, "c7")
m.addConstr(5 * vitamin_b5 + 20 * zinc + 31 * vitamin_b7 + 14 * vitamin_b4 + 31 * calcium <= 601, "c8") # Resource constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

