
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="vitamin_B5", lb=0)  # milligrams of vitamin B5
    x1 = model.addVar(name="zinc", lb=0)     # milligrams of zinc
    x2 = model.addVar(name="vitamin_B7", lb=0)  # milligrams of vitamin B7
    x3 = model.addVar(name="vitamin_B4", lb=0)  # milligrams of vitamin B4
    x4 = model.addVar(name="calcium", lb=0)    # milligrams of calcium

    # Objective function
    model.setObjective(5.81*x0 + 4.93*x1 + 5.73*x2 + 8.21*x3 + 8.07*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x0 + 20*x1 + 31*x2 >= 69)
    model.addConstr(5*x0 + 20*x1 + 14*x3 >= 69)
    model.addConstr(5*x0 + 20*x1 + 31*x2 >= 80)
    model.addConstr(5*x0 + 20*x1 + 14*x3 >= 80)
    model.addConstr(5*x0 + 31*x4 <= 486)
    model.addConstr(20*x1 + 31*x2 <= 213)
    model.addConstr(5*x0 + 20*x1 + 31*x2 + 14*x3 + 31*x4 <= 213)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Vitamin B5: ", x0.varValue)
        print("Zinc: ", x1.varValue)
        print("Vitamin B7: ", x2.varValue)
        print("Vitamin B4: ", x3.varValue)
        print("Calcium: ", x4.varValue)
    else:
        print("No optimal solution found")

optimize()
