
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
potassium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
magnesium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_magnesium")

# Set objective function
model.setObjective(4 * potassium + 5 * magnesium, GRB.MINIMIZE)

# Add constraints
model.addConstr(23 * potassium + 14 * magnesium >= 39, "digestive_support_lower_bound")
model.addConstr(24 * potassium + 28 * magnesium >= 125, "cognitive_performance_lower_bound")
model.addConstr(potassium - 8 * magnesium >= 0, "potassium_magnesium_ratio")
model.addConstr(23 * potassium + 14 * magnesium <= 58, "digestive_support_upper_bound")
model.addConstr(24 * potassium + 28 * magnesium <= 219, "cognitive_performance_upper_bound")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Milligrams of Potassium: {potassium.x}")
    print(f"  Milligrams of Magnesium: {magnesium.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

