
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="milligrams_of_potassium", lb=0, ub=GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_magnesium", lb=0, ub=GRB.INFINITY)

# Objective function: Minimize 4*x0 + 5*x1
m.setObjective(4*x0 + 5*x1, GRB.MINIMIZE)

# Constraints
# Combined digestive support index >= 39 and <= 58
m.addConstr(23*x0 + 14*x1 >= 39, name="digestive_support_min")
m.addConstr(23*x0 + 14*x1 <= 58, name="digestive_support_max")

# Combined cognitive performance index >= 125 and <= 219
m.addConstr(24*x0 + 28*x1 >= 125, name="cognitive_performance_min")
m.addConstr(24*x0 + 28*x1 <= 219, name="cognitive_performance_max")

# x0 - 8*x1 >= 0
m.addConstr(x0 - 8*x1 >= 0, name="potassium_magnesium_ratio")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Potassium: {x0.x}")
    print(f"Milligrams of Magnesium: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
