
import gurobi

def optimize_milligrams():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    potassium = model.addVar(name="potassium", lb=0)  # Assuming non-negative
    magnesium = model.addVar(name="magnesium", lb=0)  # Assuming non-negative

    # Objective function: Minimize 4 * potassium + 5 * magnesium
    model.setObjective(4 * potassium + 5 * magnesium, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(23 * potassium + 14 * magnesium >= 39, name="digestive_support_min")
    model.addConstr(24 * potassium + 28 * magnesium >= 125, name="cognitive_performance_min")
    model.addConstr(23 * potassium + 14 * magnesium <= 58, name="digestive_support_max")
    model.addConstr(24 * potassium + 28 * magnesium <= 219, name="cognitive_performance_max")
    model.addConstr(potassium - 8 * magnesium >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milligrams of Potassium: {potassium.varValue}")
        print(f"Milligrams of Magnesium: {magnesium.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("The model is infeasible.")

optimize_milligrams()
