
import gurobipy as gp

# Create a new model
m = gp.Model("Minimize Labor Cost")

# Create variables
paul = m.addVar(lb=0, name="Paul")
peggy = m.addVar(lb=0, name="Peggy")
jean = m.addVar(lb=0, name="Jean")
dale = m.addVar(lb=0, name="Dale")

# Set objective function
m.setObjective(2.91 * paul + 4.55 * peggy + 2.66 * jean + 5.97 * dale, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * peggy + 11 * dale >= 71, "c1")
m.addConstr(9 * paul + 11 * dale >= 39, "c2")
m.addConstr(9 * paul + 8 * peggy >= 61, "c3")
m.addConstr(9 * paul + 8 * peggy + 27 * jean >= 72, "c4")
m.addConstr(9 * paul + 27 * jean + 11 * dale >= 72, "c5")
m.addConstr(8 * peggy + 27 * jean + 11 * dale >= 72, "c6")
m.addConstr(9 * paul + 8 * peggy + 27 * jean >= 52, "c7")
m.addConstr(9 * paul + 27 * jean + 11 * dale >= 52, "c8")
m.addConstr(8 * peggy + 27 * jean + 11 * dale >= 52, "c9")
m.addConstr(9 * paul + 8 * peggy + 27 * jean >= 66, "c10")
m.addConstr(9 * paul + 27 * jean + 11 * dale >= 66, "c11")
m.addConstr(8 * peggy + 27 * jean + 11 * dale >= 66, "c12")
m.addConstr(9 * paul + 8 * peggy + 27 * jean + 11 * dale >= 66, "c13")
m.addConstr(26 * peggy + 31 * jean >= 45, "c14")
m.addConstr(26 * peggy + 9 * dale >= 50, "c15")
m.addConstr(26 * peggy + 31 * jean + 9 * dale >= 56, "c16")
m.addConstr(10 * paul + 26 * peggy + 31 * jean + 9 * dale >= 56, "c17")
m.addConstr(7 * paul + 24 * peggy >= 87, "c18")
m.addConstr(29 * jean + 29 * dale >= 37, "c19")
m.addConstr(7 * paul + 29 * jean >= 34, "c20")
m.addConstr(7 * paul + 29 * dale >= 34, "c21")
m.addConstr(7 * paul + 24 * peggy + 29 * jean + 29 * dale >= 34, "c22")
m.addConstr(4 * paul - peggy >= 0, "c23")
m.addConstr(9 * paul + 8 * peggy <= 209, "c24")
m.addConstr(8 * peggy + 11 * dale <= 209, "c25")
m.addConstr(8 * peggy + 27 * jean <= 78, "c26")
m.addConstr(9 * paul + 27 * jean <= 269, "c27")
m.addConstr(9 * paul + 11 * dale <= 176, "c28")
m.addConstr(9 * paul + 8 * peggy + 11 * dale <= 109, "c29")
m.addConstr(9 * paul + 27 * jean + 11 * dale <= 108, "c30")
m.addConstr(10 * paul + 31 * jean <= 109, "c31")
m.addConstr(26 * peggy + 9 * dale <= 138, "c32")
m.addConstr(10 * paul + 31 * jean + 9 * dale <= 167, "c33")
m.addConstr(26 * peggy + 31 * jean + 9 * dale <= 177, "c34")
m.addConstr(10 * paul + 26 * peggy + 31 * jean <= 93, "c35")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
