
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
P = m.addVar(lb=0, name="hours_worked_by_Paul")
G = m.addVar(lb=0, name="hours_worked_by_Peggy")
J = m.addVar(lb=0, name="hours_worked_by_Jean")
D = m.addVar(lb=0, name="hours_worked_by_Dale")

# Define the objective function
m.setObjective(2.91*P + 4.55*G + 2.66*J + 5.97*D, gp.GRB.MINIMIZE)

# Organization score constraints
m.addConstr(8*G + 11*D >= 71, name="org_score_Peggy_Dale")
m.addConstr(9*P + 11*D >= 39, name="org_score_Paul_Dale")
m.addConstr(9*P + 8*G >= 61, name="org_score_Paul_Peggy")
m.addConstr(9*P + 8*G + 27*J >= 72, name="org_score_Paul_Peggy_Jean")
m.addConstr(9*P + 27*J + 11*D >= 72, name="org_score_Paul_Jean_Dale")
m.addConstr(8*G + 27*J + 11*D >= 72, name="org_score_Peggy_Jean_Dale")
m.addConstr(9*P + 8*G + 27*J >= 52, name="org_score_Paul_Peggy_Jean_min")
m.addConstr(9*P + 27*J + 11*D >= 52, name="org_score_Paul_Jean_Dale_min")
m.addConstr(8*G + 27*J + 11*D >= 52, name="org_score_Peggy_Jean_Dale_min")
m.addConstr(9*P + 8*G + 27*J >= 66, name="org_score_Paul_Peggy_Jean_min2")
m.addConstr(9*P + 27*J + 11*D >= 66, name="org_score_Paul_Jean_Dale_min2")
m.addConstr(8*G + 27*J + 11*D >= 66, name="org_score_Peggy_Jean_Dale_min2")
m.addConstr(9*P + 8*G + 27*J + 11*D >= 66, name="org_score_all_min")

# Likelihood to quit index constraints
m.addConstr(26*G + 31*J >= 45, name="quit_index_Peggy_Jean")
m.addConstr(26*G + 9*D >= 50, name="quit_index_Peggy_Dale")
m.addConstr(26*G + 31*J + 9*D >= 56, name="quit_index_Peggy_Jean_Dale")
m.addConstr(10*P + 26*G + 31*J + 9*D >= 56, name="quit_index_all")

# Productivity rating constraints
m.addConstr(7*P + 24*G >= 87, name="productivity_Paul_Peggy")
m.addConstr(29*J + 29*D >= 37, name="productivity_Jean_Dale")
m.addConstr(7*P + 29*J >= 34, name="productivity_Paul_Jean")
m.addConstr(7*P + 29*D >= 34, name="productivity_Paul_Dale")
m.addConstr(7*P + 24*G + 29*J + 29*D >= 34, name="productivity_all")

# Other constraints
m.addConstr(4*P - G >= 0, name="other_constraint1")
m.addConstr(9*P + 8*G <= 209, name="other_constraint2")
m.addConstr(8*G + 11*D <= 209, name="other_constraint3")
m.addConstr(8*G + 27*J <= 78, name="other_constraint4")
m.addConstr(9*P + 27*J <= 269, name="other_constraint5")
m.addConstr(9*P + 11*D <= 176, name="other_constraint6")
m.addConstr(9*P + 8*G + 11*D <= 109, name="other_constraint7")
m.addConstr(9*P + 27*J + 11*D <= 108, name="other_constraint8")
m.addConstr(10*P + 31*J <= 109, name="other_constraint9")
m.addConstr(26*G + 9*D <= 138, name="other_constraint10")
m.addConstr(10*P + 31*J + 9*D <= 167, name="other_constraint11")
m.addConstr(26*G + 31*J + 9*D <= 177, name="other_constraint12")
m.addConstr(10*P + 26*G + 31*J <= 93, name="other_constraint13")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", P.varValue)
    print("Hours worked by Peggy: ", G.varValue)
    print("Hours worked by Jean: ", J.varValue)
    print("Hours worked by Dale: ", D.varValue)
else:
    print("The model is infeasible")
