
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="peanutbutter_sandwiches", lb=0)  
x1 = m.addVar(name="oreos", lb=0)  
x2 = m.addVar(name="kiwis", lb=0)  
x3 = m.addVar(name="fruit_salads", lb=0)  
x4 = m.addVar(name="milkshakes", lb=0)  
x5 = m.addVar(name="eggs", lb=0)  

# Objective function
m.setObjective(4.47*x0 + 7.12*x1 + 3.96*x2 + 7.26*x3 + 9.54*x4 + 7.14*x5, gp.GRB.MINIMIZE)

# Constraints
# Umami index constraints
m.addConstr(14*x0 + 4*x3 >= 12)  
m.addConstr(2*x2 + 2*x4 >= 15)  
m.addConstr(2*x2 + 4*x3 >= 9)  
m.addConstr(14*x0 + 2*x2 >= 8)  
m.addConstr(4*x3 + 11*x5 >= 6)  
m.addConstr(14*x0 + 2*x4 >= 5)  
m.addConstr(13*x1 + 4*x3 >= 5)  
m.addConstr(14*x0 + 11*x5 >= 14)  
m.addConstr(4*x3 + 2*x4 >= 6)  
m.addConstr(13*x1 + 2*x4 + 11*x5 >= 15)  
m.addConstr(14*x0 + 13*x1 + 2*x2 + 4*x3 + 2*x4 + 11*x5 >= 15)  

# Fat constraints
m.addConstr(14*x2 + 13*x4 >= 50)  
m.addConstr(6*x3 + 14*x5 >= 49)  
m.addConstr(11*x0 + 6*x3 >= 57)  
m.addConstr(14*x2 + 6*x3 >= 21)  
m.addConstr(13*x4 + 14*x5 >= 48)  
m.addConstr(5*x1 + 14*x5 >= 39)  
m.addConstr(5*x1 + 13*x4 >= 25)  
m.addConstr(5*x1 + 14*x2 >= 43)  
m.addConstr(14*x2 + 14*x5 >= 32)  
m.addConstr(11*x0 + 14*x5 >= 37)  
m.addConstr(11*x0 + 5*x1 + 14*x2 + 6*x3 + 13*x4 + 14*x5 >= 37)  

# Linear constraints
m.addConstr(2*x1 - 4*x3 >= 0)  

# Umami index limit constraints
m.addConstr(13*x1 + 2*x2 + 4*x3 <= 88)  
m.addConstr(2*x2 + 2*x4 + 11*x5 <= 33)  
m.addConstr(13*x1 + 4*x3 + 2*x4 <= 53)  
m.addConstr(2*x2 + 4*x3 + 2*x4 <= 29)  
m.addConstr(13*x1 + 2*x4 + 11*x5 <= 79)  
m.addConstr(4*x3 + 2*x4 + 11*x5 <= 97)  
m.addConstr(14*x0 + 4*x3 + 2*x4 <= 43)  
m.addConstr(13*x1 + 2*x2 + 2*x4 <= 25)  
m.addConstr(14*x0 + 13*x1 + 2*x2 <= 99)  
m.addConstr(14*x0 + 13*x1 + 2*x4 <= 51)  
m.addConstr(2*x2 + 4*x3 + 11*x5 <= 44)  
m.addConstr(13*x1 + 2*x2 + 11*x5 <= 35)  
m.addConstr(13*x1 + 4*x3 + 11*x5 <= 82)  

# Fat limit constraints
m.addConstr(5*x1 + 13*x4 <= 369)  
m.addConstr(11*x0 + 14*x2 + 13*x4 <= 386)  
m.addConstr(11*x0 + 13*x4 + 14*x5 <= 371)  
m.addConstr(11*x0 + 5*x1 + 14*x2 <= 258)  
m.addConstr(14*x2 + 6*x3 + 13*x4 <= 276)  
m.addConstr(11*x0 + 6*x3 + 13*x4 <= 194)  

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("peanutbutter sandwiches: ", x0.varValue)
    print("oreos: ", x1.varValue)
    print("kiwis: ", x2.varValue)
    print("fruit salads: ", x3.varValue)
    print("milkshakes: ", x4.varValue)
    print("eggs: ", x5.varValue)
else:
    print("The model is infeasible")
