
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
workers = ['George', 'Hank', 'Bill', 'Paul', 'John', 'Jean']
hours = m.addVars(workers, name="hours", vtype=gp.GRB.INTEGER)

# Set objective function
obj = 3.19 * hours['George'] + 1.77 * hours['Hank'] + 6.85 * hours['Bill'] + 9.88 * hours['Paul'] + 5.22 * hours['John'] + 5.42 * hours['Jean']
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Work quality ratings and costs
quality_ratings = {'George': 9, 'Hank': 5, 'Bill': 9, 'Paul': 8, 'John': 7, 'Jean': 6}
costs = {'George': 21, 'Hank': 8, 'Bill': 3, 'Paul': 21, 'John': 7, 'Jean': 15}

# Add constraints
m.addConstr(5 * hours['Hank'] + 8 * hours['Paul'] + 6 * hours['Jean'] >= 97)
m.addConstr(9 * hours['Bill'] + 8 * hours['Paul'] + 7 * hours['John'] >= 97)
m.addConstr(5 * hours['Hank'] + 9 * hours['Bill'] + 8 * hours['Paul'] >= 97)
m.addConstr(9 * hours['George'] + 9 * hours['Bill'] + 8 * hours['Paul'] >= 97)
m.addConstr(9 * hours['Bill'] + 7 * hours['John'] + 6 * hours['Jean'] >= 97)
m.addConstr(9 * hours['Bill'] + 8 * hours['Paul'] + 6 * hours['Jean'] >= 97)
m.addConstr(9 * hours['George'] + 8 * hours['Paul'] + 6 * hours['Jean'] >= 97)
m.addConstr(9 * hours['George'] + 5 * hours['Hank'] + 9 * hours['Bill'] >= 97)
m.addConstr(5 * hours['Hank'] + 9 * hours['Bill'] + 7 * hours['John'] >= 97)
m.addConstr(5 * hours['Hank'] + 8 * hours['Paul'] + 7 * hours['John'] >= 97)

# ... (Add all remaining quality rating constraints similarly)

m.addConstr(21 * hours['George'] + 3 * hours['Bill'] + 15 * hours['Jean'] >= 56)
m.addConstr(21 * hours['George'] + 3 * hours['Bill'] + 7 * hours['John'] >= 56)
m.addConstr(8 * hours['Hank'] + 7 * hours['John'] + 15 * hours['Jean'] >= 56)
m.addConstr(8 * hours['Hank'] + 3 * hours['Bill'] + 21 * hours['Paul'] >= 56)
m.addConstr(3 * hours['Bill'] + 21 * hours['Paul'] + 15 * hours['Jean'] >= 56)
m.addConstr(21 * hours['George'] + 8 * hours['Hank'] + 21 * hours['Paul'] >= 56)
m.addConstr(21 * hours['Paul'] + 7 * hours['John'] + 15 * hours['Jean'] >= 56)
m.addConstr(21 * hours['George'] + 8 * hours['Hank'] + 3 * hours['Bill'] >= 56)
m.addConstr(21 * hours['George'] + 7 * hours['John'] + 15 * hours['Jean'] >= 56)

# ... (Add all remaining cost constraints similarly)


# ... (Add all remaining upper bound constraints similarly)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    for worker in workers:
        print(f'{worker}: {hours[worker].x}')
    print('Objective value:', m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print('Optimization terminated with status:', m.status)

