
from gurobipy import *

# Create a new model
m = Model("Work_Quality_Rating")

# Decision Variables: Hours worked by each person
George = m.addVar(vtype=GRB.INTEGER, name="George")
Hank = m.addVar(vtype=GRB.INTEGER, name="Hank")
Bill = m.addVar(vtype=GRB.INTEGER, name="Bill")
Paul = m.addVar(vtype=GRB.INTEGER, name="Paul")
John = m.addVar(vtype=GRB.INTEGER, name="John")
Jean = m.addVar(vtype=GRB.INTEGER, name="Jean")

# Constraints
# Work Quality Ratings
m.addConstr(George + Hank + Bill >= 108, "Min_Work_Quality_GHB")  # Example constraint, adjust according to actual constraints
m.addConstr(George + Paul + John <= 643, "Max_Work_Quality_GPJ")
m.addConstr(Hank + Bill + Jean <= 171, "Max_Work_Quality_HBJ")

# Dollar Cost per Hour
m.addConstr(Bill + Jean <= 529, "Max_Dollar_Cost_BJ")
m.addConstr(John + Jean <= 292, "Max_Dollar_Cost_JJ")
m.addConstr(George + Jean <= 265, "Max_Dollar_Cost_GJ")

# Add more constraints here based on the problem statement

# Objective Function: Assuming maximize total work quality rating
m.setObjective(George + Hank + Bill + Paul + John + Jean, GRB.MAXIMIZE)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
