
import gurobi as gp

# Define variables
G = gp.Var(name="George", lb=0, vtype=gp.GRB.INTEGER)
H = gp.Var(name="Hank", lb=0, vtype=gp.GRB.INTEGER)
B = gp.Var(name="Bill", lb=0, vtype=gp.GRB.INTEGER)
P = gp.Var(name="Paul", lb=0, vtype=gp.GRB.INTEGER)
J = gp.Var(name="John", lb=0, vtype=gp.GRB.INTEGER)
E = gp.Var(name="Jean", lb=0, vtype=gp.GRB.INTEGER)

# Objective function
m = gp.Model()
m.setObjective(3.19*G + 1.77*H + 6.85*B + 9.88*P + 5.22*J + 5.42*E, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(9*G + 5*H + 9*B + 8*P + 7*J + 6*E <= 653, name='work_quality')
m.addConstr(21*G + 8*H + 3*B + 21*P + 7*J + 15*E <= 644, name='dollar_cost')

m.addConstr(5*H + 8*P + 6*E >= 97)
m.addConstr(9*B + 8*P + 7*J >= 97)

try:
    m.optimize()
    if m.status == gp.GRB.Status.OPTIMAL:
        print("Objective: ", m.objVal)
        print("George: ", G.varValue)
        print("Hank: ", H.varValue)
        print("Bill: ", B.varValue)
        print("Paul: ", P.varValue)
        print("John: ", J.varValue)
        print("Jean: ", E.varValue)
    else:
        print("No solution found")
except gp.GRB.Error as e:
    print("Error: ", e)
