
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
x1 = m.addVar(vtype=GRB.INTEGER, name="network administrators")

# Set objective function
m.setObjective(4 * x0 * x0 + 4 * x0, GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * x0 + 9 * x1 >= 15, "cost_lower_bound")
m.addConstr(17 * x0 + 17 * x1 >= 11, "data_integrity_lower_bound")
m.addConstr(4 * x0 - 6 * x1 >= 0, "bandwidth_admin_relation")
m.addConstr(17 * x0 + 9 * x1 <= 55, "cost_upper_bound")
m.addConstr(17 * x0 * x0 + 17 * x1 * x1 <= 18, "data_integrity_squared_upper_bound")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Mbps bandwidth allocated to monitoring: {x0.x}")
    print(f"network administrators: {x1.x}")
    print(f"Objective Value: {m.objVal}")

