
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")
x1 = m.addVar(vtype=GRB.INTEGER, name="network_administrators")

# Objective function
m.setObjective(4*x0**2 + 4*x0, GRB.MINIMIZE)

# Constraints
m.addConstr(17*x0 + 9*x1 >= 15, "Total_cost_lower_bound")
m.addConstr(17*x0 + 17*x1 >= 11, "Data_integrity_impact_lower_bound")
m.addConstr(4*x0 - 6*x1 >= 0, "Mixed_constraint")
m.addConstr(17*x0 + 9*x1 <= 55, "Total_cost_upper_bound")
m.addConstr((17*x0)**2 + (17*x1)**2 <= 18, "Data_integrity_impact_squared_upper_bound")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Mbps bandwidth allocated to monitoring: {x0.x}")
    print(f"Network administrators: {x1.x}")
else:
    print("No optimal solution found. The model may be infeasible.")
