
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="Mbps_bandwidth_allocated_to_monitoring", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 4*x0^2 + 4*x0
    model.setObjective(4*x0**2 + 4*x0, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17*x0 + 9*x1 >= 15, name="cost_constraint_min")
    model.addConstr(17*x0 + 9*x1 <= 57, name="cost_constraint_max")
    model.addConstr(17*x0 + 17*x1 >= 11, name="data_integrity_impact")
    model.addConstr(17**2*x0**2 + 17**2*x1**2 <= 18, name="combined_impact_squared")
    model.addConstr(4*x0 - 6*x1 >= 0, name="linear_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Mbps bandwidth allocated to monitoring: {x0.varValue}")
        print(f"Network administrators: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
