
from gurobipy import Model, GRB

# Create a new model
model = Model("WorkHourOptimization")

# Create variables
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mary_Hours")
bill_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="Bill_Hours")
john_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="John_Hours")
bobby_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="Bobby_Hours")

# Set objective function
model.setObjective(9.41 * mary_hours + 6.59 * bill_hours + 3.37 * john_hours + 1.98 * bobby_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * bill_hours + 2 * john_hours + 2 * bobby_hours >= 4, "c1")
model.addConstr(4 * mary_hours + 5 * bill_hours + 2 * john_hours >= 4, "c2")
model.addConstr(5 * bill_hours + 2 * john_hours + 2 * bobby_hours >= 4, "c3")
model.addConstr(4 * mary_hours + 5 * bill_hours + 2 * john_hours >= 4, "c4")
model.addConstr(4 * mary_hours + 1 * bill_hours + 3 * john_hours >= 8, "c5")
model.addConstr(4 * bill_hours + 4 * john_hours >= 7, "c6")
model.addConstr(4 * bill_hours + 4 * john_hours + 3 * bobby_hours >= 5, "c7")
model.addConstr(2 * mary_hours + 4 * john_hours + 3 * bobby_hours >= 5, "c8")
model.addConstr(4 * bill_hours + 4 * john_hours + 3 * bobby_hours >= 7, "c9")
model.addConstr(2 * mary_hours + 4 * john_hours + 3 * bobby_hours >= 7, "c10")
model.addConstr(4 * mary_hours + 2 * bobby_hours <= 15, "c11")
model.addConstr(4 * mary_hours + 5 * bill_hours <= 14, "c12")
model.addConstr(4 * mary_hours + 5 * bill_hours + 2 * bobby_hours <= 10, "c13")
model.addConstr(4 * mary_hours + 5 * bill_hours + 2 * john_hours + 2 * bobby_hours <= 10, "c14")
model.addConstr(1 * bill_hours + 3 * john_hours <= 29, "c15")
model.addConstr(3 * john_hours + 3 * bobby_hours <= 19, "c16")
model.addConstr(4 * mary_hours + 1 * bill_hours <= 17, "c17")
model.addConstr(1 * bill_hours + 3 * john_hours + 3 * bobby_hours <= 25, "c18")
model.addConstr(4 * mary_hours + 3 * john_hours + 3 * bobby_hours <= 13, "c19")
model.addConstr(4 * mary_hours + 1 * bill_hours + 3 * bobby_hours <= 22, "c20")
model.addConstr(4 * mary_hours + 1 * bill_hours + 3 * john_hours + 3 * bobby_hours <= 22, "c21")
model.addConstr(4 * bill_hours + 4 * john_hours <= 22, "c22")
model.addConstr(2 * mary_hours + 3 * bobby_hours <= 7, "c23")
model.addConstr(4 * john_hours + 3 * bobby_hours <= 14, "c24")
model.addConstr(2 * mary_hours + 4 * john_hours <= 23, "c25")
model.addConstr(2 * mary_hours + 4 * bill_hours + 4 * john_hours + 3 * bobby_hours <= 23, "c26")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
