
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
M = m.addVar(lb=0, name="hours_worked_by_Mary", vtype=gurobi.GRB.CONTINUOUS)
B = m.addVar(lb=0, name="hours_worked_by_Bill", vtype=gurobi.GRB.INTEGER)
J = m.addVar(lb=0, name="hours_worked_by_John", vtype=gurobi.GRB.INTEGER)
Bo = m.addVar(lb=0, name="hours_worked_by_Bobby", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(9.41 * M + 6.59 * B + 3.37 * J + 1.98 * Bo, gurobi.GRB.MAXIMIZE)

# Add constraints
# Productivity rating constraints
m.addConstr(5 * B + 2 * J + 2 * Bo >= 4, name="productivity_rating_1")
m.addConstr(4 * M + 5 * B + 2 * J >= 4, name="productivity_rating_2")
m.addConstr(4 * M + 2 * J + 2 * Bo >= 4, name="productivity_rating_3")

# Organization score constraints
m.addConstr(4 * M + B + 3 * J + 3 * Bo >= 8, name="organization_score_1")
m.addConstr(B + 3 * J >= 7, name="organization_score_2")
m.addConstr(B + 3 * J + 3 * Bo >= 5, name="organization_score_3")
m.addConstr(2 * M + 4 * J + 3 * Bo >= 5, name="organization_score_4")
m.addConstr(B + 4 * J + 3 * Bo >= 7, name="organization_score_5")
m.addConstr(2 * M + 4 * J + 3 * Bo >= 7, name="organization_score_6")

# Dollar cost per hour constraints
m.addConstr(4 * B + 4 * J <= 22, name="dollar_cost_1")
m.addConstr(2 * M + 3 * Bo <= 7, name="dollar_cost_2")
m.addConstr(4 * J + 3 * Bo <= 14, name="dollar_cost_3")
m.addConstr(2 * M + 4 * J <= 23, name="dollar_cost_4")
m.addConstr(2 * M + 4 * B + 4 * J + 3 * Bo <= 23, name="dollar_cost_5")

# Other constraints
m.addConstr(4 * M + 2 * Bo <= 15, name="other_1")
m.addConstr(4 * M + 5 * B <= 14, name="other_2")
m.addConstr(4 * M + 5 * B + 2 * Bo <= 10, name="other_3")
m.addConstr(4 * M + 5 * B + 2 * J + 2 * Bo <= 10, name="other_4")
m.addConstr(B + 3 * J <= 29, name="other_5")
m.addConstr(3 * J + 3 * Bo <= 19, name="other_6")
m.addConstr(4 * M + B <= 17, name="other_7")
m.addConstr(B + 3 * J + 3 * Bo <= 25, name="other_8")
m.addConstr(4 * M + 3 * J + 3 * Bo <= 13, name="other_9")
m.addConstr(4 * M + B + 3 * Bo <= 22, name="other_10")
m.addConstr(4 * M + 5 * B + 2 * J + 3 * Bo <= 22, name="other_11")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Mary: ", M.varValue)
    print("Hours worked by Bill: ", B.varValue)
    print("Hours worked by John: ", J.varValue)
    print("Hours worked by Bobby: ", Bo.varValue)
else:
    print("The model is infeasible")
