
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
john_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="john_hours")
hank_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")
ringo_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="ringo_hours")
george_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george_hours")

# Set objective function
m.setObjective(7.06*john_hours**2 + 5.23*john_hours*hank_hours + 9.99*hank_hours**2 + 9.34*hank_hours*ringo_hours + 4.35*hank_hours*george_hours + 4.75*ringo_hours*george_hours + 10.0*george_hours**2 + 8.85*ringo_hours + 4.39*george_hours, GRB.MINIMIZE)

# Resource coefficients
likelihood_to_quit = [19, 12, 21, 17]
paperwork_competence = [6, 7, 22, 1]
organization_score = [1, 8, 3, 29]
work_quality = [13, 28, 11, 15]

variables = [john_hours, hank_hours, ringo_hours, george_hours]

# Add constraints
m.addConstr(12*hank_hours + 17*george_hours >= 29, "c1")
m.addConstr(19*john_hours + 12*hank_hours >= 36, "c2")
m.addConstr(21*ringo_hours + 17*george_hours >= 23, "c3")
m.addConstr(12*hank_hours + 21*ringo_hours + 17*george_hours >= 36, "c4")
m.addConstr(quicksum(likelihood_to_quit[i] * variables[i] for i in range(4)) >= 36, "c5")

m.addConstr(6*john_hours + 1*george_hours >= 26, "c6")
m.addConstr(6*john_hours**2 + 7*hank_hours**2 >= 8, "c7")
m.addConstr(22*ringo_hours + 1*george_hours >= 15, "c8")
m.addConstr(6*john_hours + 7*hank_hours + 1*george_hours >= 23, "c9")
m.addConstr(quicksum(paperwork_competence[i] * variables[i] for i in range(4)) >= 23, "c10")

m.addConstr(8*hank_hours + 3*ringo_hours >= 107, "c11")
m.addConstr(1*john_hours + 29*george_hours >= 52, "c12")
m.addConstr(1*john_hours**2 + 3*ringo_hours**2 >= 42, "c13")
m.addConstr(1*john_hours + 3*ringo_hours + 29*george_hours >= 81, "c14")
m.addConstr(quicksum(organization_score[i] * variables[i] for i in range(4)) >= 81, "c15")

m.addConstr(28*hank_hours**2 + 11*ringo_hours**2 >= 33, "c16")
m.addConstr(13*john_hours + 28*hank_hours >= 29, "c17")
m.addConstr(11*ringo_hours + 15*george_hours >= 37, "c18")
m.addConstr(13*john_hours + 15*george_hours >= 33, "c19")
m.addConstr(13*john_hours + 11*ringo_hours >= 27, "c20")
m.addConstr(13*john_hours + 28*hank_hours + 11*ringo_hours >= 36, "c21")
m.addConstr(28*hank_hours**2 + 11*ringo_hours**2 + 15*george_hours**2 >= 36, "c22")
m.addConstr(13*john_hours + 28*hank_hours + 15*george_hours >= 36, "c23")
m.addConstr(13*john_hours + 28*hank_hours + 11*ringo_hours >= 52, "c24")
m.addConstr(28*hank_hours + 11*ringo_hours + 15*george_hours >= 52, "c25")
m.addConstr(13*john_hours + 28*hank_hours + 15*george_hours >= 52, "c26")
m.addConstr(13*john_hours**2 + 28*hank_hours**2 + 11*ringo_hours**2 >= 47, "c27")
m.addConstr(28*hank_hours**2 + 11*ringo_hours**2 + 15*george_hours**2 >= 47, "c28")
m.addConstr(13*john_hours**2 + 28*hank_hours**2 + 15*george_hours**2 >= 47, "c29")
m.addConstr(quicksum(work_quality[i] * variables[i] for i in range(4)) >= 47, "c30")


m.addConstr(-3*john_hours + 7*hank_hours >= 0, "c31")
m.addConstr(-2*john_hours + 1*ringo_hours >= 0, "c32")

m.addConstr(21*ringo_hours + 17*george_hours <= 152, "c33")
m.addConstr(12*hank_hours + 17*george_hours <= 134, "c34")
m.addConstr(19*john_hours + 21*ringo_hours <= 195, "c35")

m.addConstr(7*hank_hours + 1*george_hours <= 46, "c36")
m.addConstr(6*john_hours + 7*hank_hours <= 52, "c37")
m.addConstr(22*ringo_hours + 1*george_hours <= 60, "c38")
m.addConstr(6*john_hours + 1*george_hours <= 60, "c39")

m.addConstr(1*john_hours + 8*hank_hours + 3*ringo_hours <= 396, "c40")
m.addConstr(1*john_hours + 3*ringo_hours + 29*george_hours <= 432, "c41")

m.addConstr(13*john_hours + 11*ringo_hours <= 205, "c42")
m.addConstr(28*hank_hours + 11*ringo_hours <= 119, "c43")
m.addConstr(13*john_hours + 28*hank_hours <= 139, "c44")
m.addConstr(28*hank_hours + 11*ringo_hours + 15*george_hours <= 126, "c45")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('John Hours:', john_hours.x)
    print('Hank Hours:', hank_hours.x)
    print('Ringo Hours:', ringo_hours.x)
    print('George Hours:', george_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
