
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize Computer Competence")

# Create variables
paul = model.addVar(lb=0, name="Paul")
bill = model.addVar(lb=0, name="Bill")
george = model.addVar(lb=0, name="George")
hank = model.addVar(lb=0, name="Hank")
john = model.addVar(lb=0, name="John")
ringo = model.addVar(lb=0, name="Ringo")
jean = model.addVar(lb=0, name="Jean")

# Set objective function
model.setObjective(6.63 * paul + 4.33 * bill + 2.22 * george + 7.29 * hank + 2.29 * john + 6.9 * ringo + 1.01 * jean, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * george + 11 * jean >= 13)
model.addConstr(8 * paul + 11 * john >= 22)
model.addConstr(2 * george + 6 * ringo >= 12)
model.addConstr(11 * bill + 2 * hank >= 28)
model.addConstr(11 * bill + 2 * george >= 13)
model.addConstr(2 * hank + 6 * ringo >= 20)
model.addConstr(6 * ringo + 11 * jean >= 17)
model.addConstr(8 * paul + 2 * hank >= 26)
model.addConstr(11 * john + 6 * ringo >= 27)
model.addConstr(8 * paul + 11 * jean >= 11)
model.addConstr(2 * george + 2 * hank <= 183)
model.addConstr(2 * george + 6 * ringo <= 198)
model.addConstr(11 * john + 11 * jean <= 96)
model.addConstr(6 * ringo + 11 * jean <= 33)
model.addConstr(11 * john + 6 * ringo <= 167)
model.addConstr(8 * paul + 6 * ringo <= 71)
model.addConstr(2 * hank + 11 * john <= 64)
model.addConstr(2 * hank + 6 * ringo <= 52)
model.addConstr(8 * paul + 2 * hank <= 138)
model.addConstr(8 * paul + 2 * george <= 49)
model.addConstr(11 * bill + 2 * george <= 36)
model.addConstr(11 * bill + 2 * george + 2 * hank <= 75)
model.addConstr(2 * george + 2 * hank + 6 * ringo <= 165)
model.addConstr(2 * hank + 6 * ringo + 11 * jean <= 205)
model.addConstr(11 * bill + 2 * george + 11 * john <= 93)
model.addConstr(8 * paul + 2 * hank + 6 * ringo <= 192)
model.addConstr(8 * paul + 11 * bill + 11 * jean <= 101)
model.addConstr(2 * george + 11 * john + 11 * jean <= 140)
model.addConstr(8 * paul + 6 * ringo + 11 * jean <= 208)
model.addConstr(2 * hank + 11 * john + 11 * jean <= 76)
model.addConstr(11 * bill + 11 * john + 11 * jean <= 151)
model.addConstr(8 * paul + 11 * bill + 2 * george + 2 * hank + 11 * john + 6 * ringo + 11 * jean <= 151)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

