
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
hours_worked_by_Paul = model.addVar(name="hours_worked_by_Paul", lb=0)
hours_worked_by_Bill = model.addVar(name="hours_worked_by_Bill", lb=0)
hours_worked_by_George = model.addVar(name="hours_worked_by_George", lb=0)
hours_worked_by_Hank = model.addVar(name="hours_worked_by_Hank", lb=0)
hours_worked_by_John = model.addVar(name="hours_worked_by_John", lb=0)
hours_worked_by_Ringo = model.addVar(name="hours_worked_by_Ringo", lb=0)
hours_worked_by_Jean = model.addVar(name="hours_worked_by_Jean", lb=0)

# Objective function coefficients
obj_coeffs = [6.63, 4.33, 2.22, 7.29, 2.29, 6.9, 1.01]
model.setObjective(obj_coeffs[0]*hours_worked_by_Paul + obj_coeffs[1]*hours_worked_by_Bill + 
                   obj_coeffs[2]*hours_worked_by_George + obj_coeffs[3]*hours_worked_by_Hank + 
                   obj_coeffs[4]*hours_worked_by_John + obj_coeffs[5]*hours_worked_by_Ringo + 
                   obj_coeffs[6]*hours_worked_by_Jean, gurobi.GRB.MAXIMIZE)

# Constraints
# Computer competence ratings
computer_competence_ratings = {'Paul': 8, 'Bill': 11, 'George': 2, 'Hank': 2, 
                              'John': 11, 'Ringo': 6, 'Jean': 11}

# Constraints
model.addConstr(2*hours_worked_by_George + 11*hours_worked_by_Jean >= 13)
model.addConstr(8*hours_worked_by_Paul + 11*hours_worked_by_John >= 22)
model.addConstr(2*hours_worked_by_George + 6*hours_worked_by_Ringo >= 12)
model.addConstr(11*hours_worked_by_Bill + 2*hours_worked_by_Hank >= 28)
model.addConstr(11*hours_worked_by_Bill + 2*hours_worked_by_George >= 13)
model.addConstr(2*hours_worked_by_Hank + 6*hours_worked_by_Ringo >= 20)
model.addConstr(6*hours_worked_by_Ringo + 11*hours_worked_by_Jean >= 17)
model.addConstr(8*hours_worked_by_Paul + 2*hours_worked_by_Hank >= 26)
model.addConstr(11*hours_worked_by_John + 6*hours_worked_by_Ringo >= 27)
model.addConstr(8*hours_worked_by_Paul + 11*hours_worked_by_Jean >= 11)
model.addConstr(2*hours_worked_by_George + 2*hours_worked_by_Hank <= 183)
model.addConstr(2*hours_worked_by_George + 6*hours_worked_by_Ringo <= 198)
model.addConstr(11*hours_worked_by_John + 11*hours_worked_by_Jean <= 96)
model.addConstr(6*hours_worked_by_Ringo + 11*hours_worked_by_Jean <= 33)
model.addConstr(11*hours_worked_by_John + 6*hours_worked_by_Ringo <= 167)
model.addConstr(8*hours_worked_by_Paul + 6*hours_worked_by_Ringo <= 71)
model.addConstr(2*hours_worked_by_Hank + 11*hours_worked_by_John <= 64)
model.addConstr(2*hours_worked_by_Hank + 6*hours_worked_by_Ringo <= 52)
model.addConstr(8*hours_worked_by_Paul + 2*hours_worked_by_Hank <= 138)
model.addConstr(8*hours_worked_by_Paul + 2*hours_worked_by_George <= 49)
model.addConstr(11*hours_worked_by_Bill + 2*hours_worked_by_George <= 36)
model.addConstr(11*hours_worked_by_Bill + 2*hours_worked_by_George + 2*hours_worked_by_Hank <= 75)
model.addConstr(2*hours_worked_by_George + 2*hours_worked_by_Hank + 6*hours_worked_by_Ringo <= 165)
model.addConstr(2*hours_worked_by_Hank + 6*hours_worked_by_Ringo + 11*hours_worked_by_Jean <= 205)
model.addConstr(11*hours_worked_by_Bill + 2*hours_worked_by_George + 11*hours_worked_by_John <= 93)
model.addConstr(8*hours_worked_by_Paul + 2*hours_worked_by_Hank + 6*hours_worked_by_Ringo <= 192)
model.addConstr(8*hours_worked_by_Paul + 11*hours_worked_by_Bill + 11*hours_worked_by_Jean <= 101)
model.addConstr(2*hours_worked_by_George + 11*hours_worked_by_John + 11*hours_worked_by_Jean <= 140)
model.addConstr(8*hours_worked_by_Paul + 6*hours_worked_by_Ringo + 11*hours_worked_by_Jean <= 208)
model.addConstr(2*hours_worked_by_Hank + 11*hours_worked_by_John + 11*hours_worked_by_Jean <= 76)
model.addConstr(11*hours_worked_by_Bill + 11*hours_worked_by_John + 11*hours_worked_by_Jean <= 151)
model.addConstr(8*hours_worked_by_Paul + 11*hours_worked_by_Bill + 2*hours_worked_by_George + 
                 2*hours_worked_by_Hank + 11*hours_worked_by_John + 6*hours_worked_by_Ringo + 
                 11*hours_worked_by_Jean <= 151)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Hours worked by Paul: ", hours_worked_by_Paul.varValue)
    print("Hours worked by Bill: ", hours_worked_by_Bill.varValue)
    print("Hours worked by George: ", hours_worked_by_George.varValue)
    print("Hours worked by Hank: ", hours_worked_by_Hank.varValue)
    print("Hours worked by John: ", hours_worked_by_John.varValue)
    print("Hours worked by Ringo: ", hours_worked_by_Ringo.varValue)
    print("Hours worked by Jean: ", hours_worked_by_Jean.varValue)
else:
    print("The model is infeasible.")
