
from gurobipy import *

try:
    # Create a new model
    model = Model("optimize_work_hours")

    # Create variables
    paul = model.addVar(lb=0, name="Paul")
    mary = model.addVar(lb=0, name="Mary")
    peggy = model.addVar(lb=0, name="Peggy")
    jean = model.addVar(lb=0, name="Jean")
    laura = model.addVar(lb=0, name="Laura")

    # Set objective function
    model.setObjective(8.01*paul*paul + 2.85*paul*mary + 4.45*paul*peggy + 9.87*paul*laura + 7.71*mary*mary + 5.93*mary*peggy + 5.22*mary*laura + 7.18*peggy*peggy + 6.06*peggy*laura + 5.23*jean*jean + 9.39*jean*laura + 9.02*paul + 9.92*mary + 4.45*peggy, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(17*peggy + 3*jean + 20*laura >= 36)
    model.addConstr(22*mary + 17*peggy + 3*jean >= 36)
    model.addConstr(12*paul*paul + 3*jean*jean + 20*laura*laura >= 36)
    model.addConstr(12*paul + 17*peggy + 20*laura >= 36)
    model.addConstr(12*paul*paul + 22*mary*mary + 17*peggy*peggy >= 36)
    model.addConstr(12*paul + 17*peggy + 3*jean >= 36)
    model.addConstr(17*peggy*peggy + 3*jean*jean + 20*laura*laura >= 35)
    model.addConstr(22*mary + 17*peggy + 3*jean >= 35)
    model.addConstr(12*paul + 3*jean + 20*laura >= 35)
    model.addConstr(12*paul*paul + 17*peggy*peggy + 20*laura*laura >= 35)
    model.addConstr(12*paul*paul + 22*mary*mary + 17*peggy*peggy >= 35)
    model.addConstr(12*paul*paul + 17*peggy*peggy + 3*jean*jean >= 35)
    model.addConstr(17*peggy*peggy + 3*jean*jean + 20*laura*laura >= 30)
    model.addConstr(22*mary + 17*peggy + 3*jean >= 30)
    model.addConstr(12*paul + 3*jean + 20*laura >= 30)
    model.addConstr(12*paul*paul + 17*peggy*peggy + 20*laura*laura >= 30)
    model.addConstr(12*paul + 22*mary + 17*peggy >= 30)
    model.addConstr(12*paul*paul + 17*peggy*peggy + 3*jean*jean >= 30)
    model.addConstr(17*peggy + 3*jean + 20*laura >= 29)
    model.addConstr(22*mary + 17*peggy + 3*jean >= 29)
    model.addConstr(12*paul*paul + 3*jean*jean + 20*laura*laura >= 29)
    model.addConstr(12*paul*paul + 17*peggy*peggy + 20*laura*laura >= 29)
    model.addConstr(12*paul*paul + 22*mary*mary + 17*peggy*peggy >= 29)
    model.addConstr(12*paul*paul + 17*peggy*peggy + 3*jean*jean >= 29)
    model.addConstr(17*peggy + 3*jean + 20*laura >= 40)
    model.addConstr(22*mary + 17*peggy + 3*jean >= 40)
    model.addConstr(12*paul*paul + 3*jean*jean + 20*laura*laura >= 40)
    model.addConstr(12*paul + 17*peggy + 20*laura >= 40)
    model.addConstr(12*paul*paul + 22*mary*mary + 17*peggy*peggy >= 40)
    model.addConstr(12*paul + 17*peggy + 3*jean >= 40)
    model.addConstr(17*peggy + 3*jean + 20*laura >= 25)
    model.addConstr(22*mary + 17*peggy + 3*jean >= 25)
    model.addConstr(12*paul + 3*jean + 20*laura >= 25)
    model.addConstr(12*paul + 17*peggy + 20*laura >= 25)
    model.addConstr(12*paul*paul + 22*mary*mary + 17*peggy*peggy >= 25)
    model.addConstr(12*paul*paul + 17*peggy*peggy + 3*jean*jean >= 25)
    model.addConstr(7*mary - 9*peggy - 8*jean >= 0)
    model.addConstr(12*paul*paul + 3*jean*jean <= 150)
    model.addConstr(22*mary*mary + 20*laura*laura <= 103)
    model.addConstr(22*mary + 3*jean <= 193)
    model.addConstr(3*jean + 20*laura <= 139)
    model.addConstr(22*mary*mary + 17*peggy*peggy <= 219)
    model.addConstr(12*paul + 17*peggy <= 164)
    model.addConstr(17*peggy*peggy + 3*jean*jean <= 114)
    model.addConstr(12*paul + 22*mary + 17*peggy + 3*jean + 20*laura <= 114)


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")

except GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
