
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Likelihood to Quit Cost")

# Create variables
bill_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bill_hours")
mary_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary_hours")
peggy_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="peggy_hours")

# Set objective function
model.setObjective(8.53 * bill_hours + 1.19 * mary_hours + 3.23 * peggy_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * mary_hours + 8 * peggy_hours >= 30, "c1")
model.addConstr(11 * bill_hours + 8 * peggy_hours >= 30, "c2")
model.addConstr(11 * bill_hours + 3 * mary_hours + 8 * peggy_hours >= 30, "c3")
model.addConstr(6 * mary_hours - 2 * peggy_hours >= 0, "c4")
model.addConstr(11 * bill_hours + 3 * mary_hours + 8 * peggy_hours <= 122, "c5")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective:', model.objVal)
    print('Bill hours:', bill_hours.x)
    print('Mary hours:', mary_hours.x)
    print('Peggy hours:', peggy_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

